/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.preset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easynpc.component.DataComponents;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record PresetData(String name, class_1299<?> entityType, class_2487 data, class_2960 location, PresetType presetType, PresetMetadata metadata) {
    public static final String ID = "preset_data";
    public static final String EMPTY_NAME = "Empty";
    public static final String ENTITY_TYPE_TAG = "EntityType";
    public static final String PRESET_TAG = "Preset";
    public static final String PRESET_UUID_TAG = "PresetUUID";
    public static final PresetData EMPTY = new PresetData("Empty", class_1299.field_6131, new class_2487(), null, null, PresetMetadata.createDefault());
    public static final Codec<PresetData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PresetData::name), (App)class_7923.field_41177.method_39673().fieldOf("entityType").forGetter(PresetData::entityType), (App)class_2487.field_25128.fieldOf("data").forGetter(PresetData::data), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(presetData -> presetData.location() != null ? Optional.of(presetData.location()) : Optional.empty()), (App)Codec.STRING.xmap(PresetType::valueOf, Enum::name).optionalFieldOf("presetType").forGetter(presetData -> presetData.presetType() != null ? Optional.of(presetData.presetType()) : Optional.empty()), (App)PresetMetadata.CODEC.optionalFieldOf("metadata", (Object)PresetMetadata.createDefault()).forGetter(PresetData::metadata)).apply((Applicative)instance, (name, entityType, data, location, presetType, metadata) -> new PresetData((String)name, (class_1299<?>)entityType, (class_2487)data, location.orElse(null), presetType.orElse(null), (PresetMetadata)metadata)));
    public static final class_9139<class_9129, PresetData> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48554, PresetData::name, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41266), PresetData::entityType, (class_9139)class_9135.field_48556, PresetData::data, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), presetData -> presetData.location() != null ? Optional.of(presetData.location()) : Optional.empty(), (class_9139)class_9135.method_56382((class_9139)class_9135.field_48554.method_56432(PresetType::valueOf, Enum::name)), presetData -> presetData.presetType() != null ? Optional.of(presetData.presetType()) : Optional.empty(), PresetMetadata.STREAM_CODEC, PresetData::metadata, (name, entityType, data, location, presetType, metadata) -> new PresetData((String)name, (class_1299<?>)entityType, (class_2487)data, location.orElse(null), presetType.orElse(null), (PresetMetadata)metadata));
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public PresetData(class_1299<?> entityType, class_2487 data) {
        this(entityType.method_5882(), entityType, PresetData.ensurePresetUUID(data), null, null, PresetMetadata.createDefault());
    }

    public PresetData(class_2960 location, PresetType presetType, PresetMetadata metadata, class_2487 data, class_1299<?> entityType) {
        this(metadata != null && metadata.name() != null && !metadata.name().isEmpty() ? metadata.name() : (location != null ? location.method_12832() : EMPTY_NAME), entityType, data, location, presetType, metadata);
    }

    private static class_2487 ensurePresetUUID(class_2487 data) {
        if (data == null) {
            return data;
        }
        if (!data.method_25928(PRESET_UUID_TAG)) {
            class_2487 updated = data.method_10553();
            updated.method_25927(PRESET_UUID_TAG, UUID.randomUUID());
            return updated;
        }
        return data;
    }

    public static PresetData fromCompoundTag(class_2960 location, PresetType presetType, class_2487 compoundTag) {
        class_2487 entityData;
        if (compoundTag == null) {
            return null;
        }
        class_2487 class_24872 = entityData = compoundTag.method_10545("data") && !compoundTag.method_10545("id") ? compoundTag.method_10562("data") : compoundTag;
        if (!entityData.method_10545("id")) {
            log.error("Missing entity ID tag in preset data: {}", (Object)compoundTag);
            return null;
        }
        class_1299 entityType = class_1299.method_5898((String)entityData.method_10558("id")).orElse(null);
        if (entityType == null) {
            log.error("Unknown entity type in preset data: {}", (Object)compoundTag);
            return null;
        }
        return new PresetData(location, presetType, PresetMetadata.fromPresetData(compoundTag), PresetData.ensurePresetUUID(entityData), entityType);
    }

    public static boolean has(class_1799 itemStack) {
        return itemStack != null && !itemStack.method_7960() && itemStack.method_57826(DataComponents.PRESET_DATA) && !((PresetData)itemStack.method_57825(DataComponents.PRESET_DATA, (Object)EMPTY)).isEmpty();
    }

    public static PresetData get(class_1799 itemStack) {
        if (!PresetData.has(itemStack)) {
            return null;
        }
        return (PresetData)itemStack.method_57824(DataComponents.PRESET_DATA);
    }

    public static class_1799 set(class_1792 item, PresetData presetData) {
        return PresetData.set(new class_1799((class_1935)item), presetData);
    }

    public static class_1799 set(class_1799 itemStack, PresetData presetData) {
        if (itemStack == null || itemStack.method_7960() || presetData == null) {
            return null;
        }
        itemStack.method_57379(DataComponents.PRESET_DATA, (Object)presetData);
        return itemStack;
    }

    public static PresetData create(String name, class_1299<?> entityType, class_2487 data, class_2960 location, PresetType presetType, PresetMetadata metadata) {
        return new PresetData(name, entityType, PresetData.ensurePresetUUID(data), location, presetType, metadata);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean hasData() {
        return this.data != null && !this.data.method_33133();
    }

    public boolean hasEntityType() {
        return this.entityType != null;
    }

    public boolean hasValidData() {
        return this.hasEntityType() && this.hasData();
    }

    public String getDisplayName() {
        if (this.location != null && this.metadata != null) {
            return CustomPresetDataFiles.getPresetDisplayName(this.location, this.metadata);
        }
        return this.name;
    }

    public PresetData withPosition(class_243 position) {
        if (position == null || this.data == null) {
            return this;
        }
        class_2487 updatedData = this.data.method_10553();
        class_2499 posTag = new class_2499();
        posTag.add((Object)class_2489.method_23241((double)position.field_1352));
        posTag.add((Object)class_2489.method_23241((double)position.field_1351));
        posTag.add((Object)class_2489.method_23241((double)position.field_1350));
        updatedData.method_10566("Pos", (class_2520)posTag);
        return new PresetData(this.name, this.entityType, updatedData, this.location, this.presetType, this.metadata);
    }

    public PresetData withUUID(UUID uuid) {
        if (uuid == null || this.data == null) {
            return this;
        }
        class_2487 updatedData = this.data.method_10553();
        updatedData.method_25927("UUID", uuid);
        return new PresetData(this.name, this.entityType, updatedData, this.location, this.presetType, this.metadata);
    }

    public UUID getPresetUUID() {
        if (this.data == null || !this.data.method_25928(PRESET_UUID_TAG)) {
            return null;
        }
        return this.data.method_25926(PRESET_UUID_TAG);
    }

    public UUID getEntityUUID() {
        if (this.data == null || !this.data.method_25928("UUID")) {
            return null;
        }
        return this.data.method_25926("UUID");
    }
}

