/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.preset;

import de.markusbordihn.easynpc.component.DataComponents;
import de.markusbordihn.easynpc.data.preset.PresetData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetDataUtils {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String[] RUNTIME_STATE_TAGS = new String[]{"Fire", "FallDistance", "OnGround", "Motion", "HurtTime", "DeathTime", "Air"};
    private static final String[] POSITION_TAGS = new String[]{"Pos", "Rotation"};
    private static final String ENTITY_UUID_TAG = "UUID";

    private PresetDataUtils() {
    }

    public static class_2487 cleanupEntityData(class_2487 entityData) {
        return PresetDataUtils.cleanupEntityData(entityData, CleanupMode.RUNTIME_ONLY);
    }

    public static class_2487 cleanupEntityData(class_2487 entityData, CleanupMode mode) {
        if (entityData == null || entityData.method_33133()) {
            return entityData;
        }
        for (String tag : RUNTIME_STATE_TAGS) {
            entityData.method_10551(tag);
        }
        if (mode == CleanupMode.FULL) {
            for (String tag : POSITION_TAGS) {
                entityData.method_10551(tag);
            }
        }
        return entityData;
    }

    public static class_1952 toSpawnData(PresetData presetData) {
        if (presetData == null || !presetData.hasValidData()) {
            return new class_1952();
        }
        class_2487 dataCopy = presetData.data().method_10553();
        if (!dataCopy.method_25928(ENTITY_UUID_TAG)) {
            dataCopy.method_25927(ENTITY_UUID_TAG, UUID.randomUUID());
            log.debug("Generated missing Entity UUID in toSpawnData");
        }
        return new class_1952(dataCopy, Optional.empty(), Optional.empty());
    }

    public static PresetData fromSpawnData(class_1952 spawnData) {
        if (spawnData == null) {
            return PresetData.EMPTY;
        }
        class_2487 entityData = spawnData.method_38093();
        if (!entityData.method_10545("id")) {
            return PresetData.EMPTY;
        }
        String entityTypeId = entityData.method_10558("id");
        class_1299 entityType = class_1299.method_5898((String)entityTypeId).orElse(null);
        if (entityType == null) {
            return PresetData.EMPTY;
        }
        return new PresetData(entityType, entityData.method_10553());
    }

    public static class_1799 toItemStack(PresetData presetData) {
        if (presetData == null || !presetData.hasValidData()) {
            log.warn("Cannot create item stack from invalid preset data");
            return class_1799.field_8037;
        }
        class_1792 item = class_7923.field_41178.method_17966(class_2960.method_60655((String)"easy_npc", (String)"easy_npc_preset")).orElse(null);
        if (item == null) {
            log.error("Cannot find easy_npc_preset item in registry");
            return class_1799.field_8037;
        }
        class_1799 itemStack = new class_1799((class_1935)item);
        itemStack.method_57379(DataComponents.PRESET_DATA, (Object)new PresetData(presetData.entityType(), PresetDataUtils.cleanupEntityData(presetData.data().method_10553(), CleanupMode.FULL)));
        return itemStack;
    }

    public static PresetData fromItemStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return PresetData.EMPTY;
        }
        PresetData presetData = (PresetData)itemStack.method_57824(DataComponents.PRESET_DATA);
        if (presetData == null) {
            return PresetData.EMPTY;
        }
        String entityTypeId = presetData.data().method_10558("EntityType");
        class_1299 entityType = class_1299.method_5898((String)entityTypeId).orElse(null);
        if (entityType == null) {
            return PresetData.EMPTY;
        }
        return presetData;
    }

    public static boolean spawnEntity(PresetData presetData, class_1937 level, class_2338 blockPos) {
        if (level.field_9236 || presetData == null || !presetData.hasValidData()) {
            return false;
        }
        class_1297 entity = presetData.entityType().method_5883(level);
        if (entity == null) {
            log.error("Unable to create entity for {} in {}", presetData.entityType(), (Object)level);
            return false;
        }
        class_2487 entityData = presetData.data().method_10553();
        if (entityData.method_10545(ENTITY_UUID_TAG)) {
            entityData.method_10551(ENTITY_UUID_TAG);
        }
        entity.method_5651(entityData);
        entity.method_24203((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
        if (level.method_8649(entity)) {
            log.debug("Spawned {} at {} in {}", presetData.entityType(), (Object)blockPos, (Object)level);
            return true;
        }
        return false;
    }

    public static enum CleanupMode {
        RUNTIME_ONLY,
        FULL;

    }
}

