/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.preset;

import java.util.Locale;

public enum PresetExportFormat {
    NBT(".npc.nbt"),
    SNBT(".npc.snbt"),
    JSON(".npc.json"),
    UNKNOWN("");

    private final String fileExtension;

    private PresetExportFormat(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public static PresetExportFormat getDefault() {
        return NBT;
    }

    public static PresetExportFormat getPresetExportFormat(String filename) {
        if (filename == null || filename.isEmpty()) {
            return UNKNOWN;
        }
        for (PresetExportFormat format : PresetExportFormat.values()) {
            if (format == UNKNOWN || !filename.endsWith(format.getFileExtension())) continue;
            return format;
        }
        return UNKNOWN;
    }

    public static String getPresetExtension(String filename) {
        PresetExportFormat format = PresetExportFormat.getPresetExportFormat(filename);
        return format != UNKNOWN ? format.getFileExtension() : null;
    }

    public static String removePresetExtension(String filename) {
        String extension = PresetExportFormat.getPresetExtension(filename);
        if (extension != null) {
            return filename.substring(0, filename.length() - extension.length());
        }
        return filename != null ? filename : "";
    }

    public static boolean hasPresetExtension(String filename) {
        return PresetExportFormat.getPresetExtension(filename) != null;
    }

    public static String extractCleanFilename(String pathOrFilename) {
        if (pathOrFilename == null || pathOrFilename.isEmpty()) {
            return "";
        }
        String filename = pathOrFilename;
        int lastSlash = filename.lastIndexOf(47);
        if (lastSlash >= 0) {
            filename = filename.substring(lastSlash + 1);
        }
        return PresetExportFormat.removePresetExtension(filename);
    }

    public static String normalizeFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            return "";
        }
        return filename.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

