/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.preset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2487;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record PresetMetadata(String name, String category, String version, String author, long created, long modified, String description, String entityTypeId, String variantType) {
    public static final String TAG_NAME = "name";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_VERSION = "version";
    public static final String TAG_AUTHOR = "author";
    public static final String TAG_CREATED = "created";
    public static final String TAG_MODIFIED = "modified";
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_ENTITY_TYPE_ID = "entityTypeId";
    public static final String TAG_VARIANT_TYPE = "variantType";
    public static final String DEFAULT_NAME = "Unnamed Preset";
    public static final String DEFAULT_CATEGORY = "Custom";
    public static final String DEFAULT_VERSION = "1.0.0";
    public static final String DEFAULT_AUTHOR = "Unknown";
    public static final String DEFAULT_DESCRIPTION = "";
    public static final Codec<PresetMetadata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf(TAG_NAME, (Object)DEFAULT_NAME).forGetter(PresetMetadata::name), (App)Codec.STRING.optionalFieldOf(TAG_CATEGORY, (Object)DEFAULT_CATEGORY).forGetter(PresetMetadata::category), (App)Codec.STRING.optionalFieldOf(TAG_VERSION, (Object)DEFAULT_VERSION).forGetter(PresetMetadata::version), (App)Codec.STRING.optionalFieldOf(TAG_AUTHOR, (Object)DEFAULT_AUTHOR).forGetter(PresetMetadata::author), (App)Codec.LONG.optionalFieldOf(TAG_CREATED, (Object)0L).forGetter(PresetMetadata::created), (App)Codec.LONG.optionalFieldOf(TAG_MODIFIED, (Object)0L).forGetter(PresetMetadata::modified), (App)Codec.STRING.optionalFieldOf(TAG_DESCRIPTION, (Object)DEFAULT_DESCRIPTION).forGetter(PresetMetadata::description), (App)Codec.STRING.optionalFieldOf(TAG_ENTITY_TYPE_ID, (Object)DEFAULT_DESCRIPTION).forGetter(metadata -> metadata.entityTypeId() != null ? metadata.entityTypeId() : DEFAULT_DESCRIPTION), (App)Codec.STRING.optionalFieldOf(TAG_VARIANT_TYPE, (Object)DEFAULT_DESCRIPTION).forGetter(metadata -> metadata.variantType() != null ? metadata.variantType() : DEFAULT_DESCRIPTION)).apply((Applicative)instance, (name, category, version, author, created, modified, description, entityTypeId, variantType) -> new PresetMetadata((String)name, (String)category, (String)version, (String)author, (long)created, (long)modified, (String)description, entityTypeId.isEmpty() ? null : entityTypeId, variantType.isEmpty() ? null : variantType)));
    public static final class_9139<class_9129, PresetMetadata> STREAM_CODEC = new class_9139<class_9129, PresetMetadata>(){

        public PresetMetadata decode(class_9129 buffer) {
            String name = buffer.method_19772();
            String category = buffer.method_19772();
            String version = buffer.method_19772();
            String author = buffer.method_19772();
            long created = buffer.method_10792();
            long modified = buffer.method_10792();
            String description = buffer.method_19772();
            String entityTypeId = buffer.method_19772();
            String variantType = buffer.method_19772();
            return new PresetMetadata(name, category, version, author, created, modified, description, entityTypeId.isEmpty() ? null : entityTypeId, variantType.isEmpty() ? null : variantType);
        }

        public void encode(class_9129 buffer, PresetMetadata metadata) {
            buffer.method_10814(metadata.name());
            buffer.method_10814(metadata.category());
            buffer.method_10814(metadata.version());
            buffer.method_10814(metadata.author());
            buffer.method_10791(metadata.created());
            buffer.method_10791(metadata.modified());
            buffer.method_10814(metadata.description());
            buffer.method_10814(metadata.entityTypeId() != null ? metadata.entityTypeId() : PresetMetadata.DEFAULT_DESCRIPTION);
            buffer.method_10814(metadata.variantType() != null ? metadata.variantType() : PresetMetadata.DEFAULT_DESCRIPTION);
        }
    };

    public PresetMetadata {
        if (name == null || name.isEmpty()) {
            name = DEFAULT_NAME;
        }
        if (category == null || category.isEmpty()) {
            category = DEFAULT_CATEGORY;
        }
        if (version == null || version.isEmpty()) {
            version = DEFAULT_VERSION;
        }
        if (author == null || author.isEmpty()) {
            author = DEFAULT_AUTHOR;
        }
        if (created <= 0L) {
            created = System.currentTimeMillis();
        }
        if (modified <= 0L) {
            modified = System.currentTimeMillis();
        }
        if (description == null) {
            description = DEFAULT_DESCRIPTION;
        }
    }

    public static PresetMetadata createDefault() {
        return new PresetMetadata(DEFAULT_NAME, DEFAULT_CATEGORY, DEFAULT_VERSION, DEFAULT_AUTHOR, System.currentTimeMillis(), System.currentTimeMillis(), DEFAULT_DESCRIPTION, null, null);
    }

    public static PresetMetadata getDefault() {
        return PresetMetadata.createDefault();
    }

    public static PresetMetadata createDefault(String name, String author) {
        return new PresetMetadata(name, DEFAULT_CATEGORY, DEFAULT_VERSION, author, System.currentTimeMillis(), System.currentTimeMillis(), DEFAULT_DESCRIPTION, null, null);
    }

    public static PresetMetadata fromCompoundTag(class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return PresetMetadata.createDefault();
        }
        return new PresetMetadata(tag.method_10545(TAG_NAME) ? tag.method_10558(TAG_NAME) : DEFAULT_NAME, tag.method_10545(TAG_CATEGORY) ? tag.method_10558(TAG_CATEGORY) : DEFAULT_CATEGORY, tag.method_10545(TAG_VERSION) ? tag.method_10558(TAG_VERSION) : DEFAULT_VERSION, tag.method_10545(TAG_AUTHOR) ? tag.method_10558(TAG_AUTHOR) : DEFAULT_AUTHOR, tag.method_10545(TAG_CREATED) ? tag.method_10537(TAG_CREATED) : System.currentTimeMillis(), tag.method_10545(TAG_MODIFIED) ? tag.method_10537(TAG_MODIFIED) : System.currentTimeMillis(), tag.method_10545(TAG_DESCRIPTION) ? tag.method_10558(TAG_DESCRIPTION) : DEFAULT_DESCRIPTION, tag.method_10545(TAG_ENTITY_TYPE_ID) ? tag.method_10558(TAG_ENTITY_TYPE_ID) : null, tag.method_10545(TAG_VARIANT_TYPE) ? tag.method_10558(TAG_VARIANT_TYPE) : null);
    }

    public static PresetMetadata fromPresetData(class_2487 presetData) {
        if (presetData == null || !presetData.method_10545("PresetMetadata")) {
            return PresetMetadata.createDefault();
        }
        PresetMetadata metadata = PresetMetadata.fromCompoundTag(presetData.method_10562("PresetMetadata"));
        if (metadata.entityTypeId() == null || metadata.variantType() == null) {
            String entityTypeId = metadata.entityTypeId();
            String variantType = metadata.variantType();
            if (entityTypeId == null && presetData.method_10545("id")) {
                entityTypeId = presetData.method_10558("id");
            }
            if (variantType == null && presetData.method_10545("VariantType")) {
                variantType = presetData.method_10558("VariantType");
            }
            if (entityTypeId != null || variantType != null) {
                metadata = metadata.withPreviewData(entityTypeId, variantType);
            }
        }
        return metadata;
    }

    public class_2487 toCompoundTag() {
        class_2487 tag = new class_2487();
        tag.method_10582(TAG_NAME, this.name);
        tag.method_10582(TAG_CATEGORY, this.category);
        tag.method_10582(TAG_VERSION, this.version);
        tag.method_10582(TAG_AUTHOR, this.author);
        tag.method_10544(TAG_CREATED, this.created);
        tag.method_10544(TAG_MODIFIED, this.modified);
        tag.method_10582(TAG_DESCRIPTION, this.description);
        if (this.entityTypeId != null && !this.entityTypeId.isEmpty()) {
            tag.method_10582(TAG_ENTITY_TYPE_ID, this.entityTypeId);
        }
        if (this.variantType != null && !this.variantType.isEmpty()) {
            tag.method_10582(TAG_VARIANT_TYPE, this.variantType);
        }
        return tag;
    }

    public PresetMetadata withModifiedTime(long modifiedTime) {
        return new PresetMetadata(this.name, this.category, this.version, this.author, this.created, modifiedTime, this.description, this.entityTypeId, this.variantType);
    }

    public PresetMetadata withCurrentModifiedTime() {
        return this.withModifiedTime(System.currentTimeMillis());
    }

    public PresetMetadata withName(String newName) {
        return new PresetMetadata(newName, this.category, this.version, this.author, this.created, System.currentTimeMillis(), this.description, this.entityTypeId, this.variantType);
    }

    public PresetMetadata withCategory(String newCategory) {
        return new PresetMetadata(this.name, newCategory, this.version, this.author, this.created, System.currentTimeMillis(), this.description, this.entityTypeId, this.variantType);
    }

    public PresetMetadata withVersion(String newVersion) {
        return new PresetMetadata(this.name, this.category, newVersion, this.author, this.created, System.currentTimeMillis(), this.description, this.entityTypeId, this.variantType);
    }

    public PresetMetadata withAuthor(String newAuthor) {
        return new PresetMetadata(this.name, this.category, this.version, newAuthor, this.created, System.currentTimeMillis(), this.description, this.entityTypeId, this.variantType);
    }

    public PresetMetadata withDescription(String newDescription) {
        return new PresetMetadata(this.name, this.category, this.version, this.author, this.created, System.currentTimeMillis(), newDescription, this.entityTypeId, this.variantType);
    }

    public PresetMetadata withPreviewData(String newEntityTypeId, String newVariantType) {
        return new PresetMetadata(this.name, this.category, this.version, this.author, this.created, this.modified, this.description, newEntityTypeId, newVariantType);
    }
}

