/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.progression;

public class ProgressionLevelMap {
    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 60;
    private static final int[] XP_FOR_LEVEL = new int[61];

    private ProgressionLevelMap() {
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 1) {
            return XP_FOR_LEVEL[1];
        }
        if (level >= 60) {
            return XP_FOR_LEVEL[60];
        }
        return XP_FOR_LEVEL[level];
    }

    public static int getExperienceForNextLevel(int level) {
        return level >= 60 ? XP_FOR_LEVEL[60] : XP_FOR_LEVEL[level + 1];
    }

    public static int getExperienceDifferenceForLevel(int level) {
        return level > 1 ? XP_FOR_LEVEL[level] - XP_FOR_LEVEL[level - 1] : 0;
    }

    private static int calculateXpForLevel(int level) {
        if (level <= 1) {
            return 1;
        }
        return (int)(Math.pow(level, 2.5) + (double)(level * 10));
    }

    public static int getLevelForExperience(int experience) {
        if (experience <= XP_FOR_LEVEL[1]) {
            return 1;
        }
        for (int level = 1; level <= 60; ++level) {
            if (experience >= XP_FOR_LEVEL[level]) continue;
            return level - 1;
        }
        return 60;
    }

    public static int getExperienceProgressToNextLevel(int experience, int level) {
        return level >= 60 ? 0 : experience - XP_FOR_LEVEL[level];
    }

    public static float getProgressPercentageToNextLevel(int experience, int level) {
        if (level >= 60) {
            return 100.0f;
        }
        int currentLevelXP = XP_FOR_LEVEL[level];
        int nextLevelXP = XP_FOR_LEVEL[level + 1];
        int progress = experience - currentLevelXP;
        return (float)progress / (float)(nextLevelXP - currentLevelXP) * 100.0f;
    }

    static {
        for (int level = 0; level <= 60; ++level) {
            ProgressionLevelMap.XP_FOR_LEVEL[level] = ProgressionLevelMap.calculateXpForLevel(level);
        }
    }
}

