/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.render;

import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import net.minecraft.class_1299;

public record EntityRenderConfig(int x, int y, int scale, float rotationYaw, float rotationPitch, int left, int top, int right, int bottom, float yOffset, EntityRenderOverrides overrides) {
    private static final int DEFAULT_RENDER_WIDTH = 300;
    private static final int DEFAULT_RENDER_HEIGHT = 300;

    private EntityRenderConfig(int x, int y, int scale, float rotationYaw, float rotationPitch, EntityRenderOverrides overrides) {
        this(x, y, scale, rotationYaw, rotationPitch, x - 150, y - 150, x + 150, y + 150, 0.0f, overrides);
    }

    private EntityRenderConfig(int x, int y, int scale, float rotationYaw, float rotationPitch, int width, int height, EntityRenderOverrides overrides) {
        this(x, y, scale, rotationYaw, rotationPitch, x - width / 2, y - height / 2, x + width / 2, y + height / 2, 0.0f, overrides);
    }

    private EntityRenderConfig(int x, int y, int scale, float rotationYaw, float rotationPitch, float yOffset, EntityRenderOverrides overrides) {
        this(x, y, scale, rotationYaw, rotationPitch, x - 150, y - 150, x + 150, y + 150, yOffset, overrides);
    }

    public static EntityRenderConfig guiScaled(int x, int y, int scale) {
        return EntityRenderConfig.guiScaled(x, y, scale, 0.0f, 0.0f);
    }

    public static EntityRenderConfig guiScaled(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.HIDE_NAME_TAG_RESET_ROOT);
    }

    public static EntityRenderConfig dialog(int x, int y, int scale) {
        return EntityRenderConfig.dialog(x, y, scale, 0.0f, 0.0f);
    }

    public static EntityRenderConfig dialog(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.HIDE_NAME_TAG_RESET_ROOT);
    }

    public static EntityRenderConfig scaling(int x, int y, int scale) {
        return EntityRenderConfig.scaling(x, y, scale, 0.0f);
    }

    public static EntityRenderConfig scaling(int x, int y, int scale, float yOffset) {
        return new EntityRenderConfig(x, y, scale, 0.0f, 0.0f, yOffset, EntityRenderOverrides.NONE.withRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f)).withHideNameTag(true));
    }

    public static EntityRenderConfig scaling(int x, int y, int scale, float rotationYaw, float rotationPitch) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.NONE.withRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f)).withHideNameTag(true));
    }

    public static EntityRenderConfig customModel(int x, int y, int scale, class_1299<?> entityType) {
        return EntityRenderConfig.customModel(x, y, scale, 0.0f, 0.0f, entityType);
    }

    public static EntityRenderConfig customModel(int x, int y, int scale, float rotationYaw, float rotationPitch, class_1299<?> entityType) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, EntityRenderOverrides.withCustomModel(RenderType.CUSTOM, entityType));
    }

    public static EntityRenderConfig withOverrides(int x, int y, int scale, EntityRenderOverrides overrides) {
        return EntityRenderConfig.withOverrides(x, y, scale, 0.0f, 0.0f, overrides);
    }

    public static EntityRenderConfig withOverrides(int x, int y, int scale, float rotationYaw, float rotationPitch, EntityRenderOverrides overrides) {
        return new EntityRenderConfig(x, y, scale, rotationYaw, rotationPitch, overrides);
    }
}

