/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.render;

import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record RenderDataEntry(RenderType renderType, class_1299<? extends class_1297> renderEntityType) {
    static final String DATA_RENDER_TYPE_TAG = "Type";
    static final String DATA_RENDER_ENTITY_TYPE_TAG = "EntityType";
    public static final class_9139<class_9129, RenderDataEntry> STREAM_CODEC = new class_9139<class_9129, RenderDataEntry>(){

        public RenderDataEntry decode(class_9129 registryFriendlyByteBuf) {
            return new RenderDataEntry(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, RenderDataEntry renderDataEntry) {
            registryFriendlyByteBuf.method_10794((class_2520)EntityDataSerializersManager.validateAndGetNbt(renderDataEntry.createTag(), "RenderDataEntry"));
        }
    };

    public RenderDataEntry() {
        this(RenderType.DEFAULT, null);
    }

    public RenderDataEntry(class_2487 compoundTag) {
        this(compoundTag.method_10545(DATA_RENDER_TYPE_TAG) ? RenderType.get(compoundTag.method_10558(DATA_RENDER_TYPE_TAG)) : RenderType.DEFAULT, compoundTag.method_10545(DATA_RENDER_ENTITY_TYPE_TAG) ? (class_1299)class_1299.method_5898((String)compoundTag.method_10558(DATA_RENDER_ENTITY_TYPE_TAG)).orElse(null) : null);
    }

    public RenderDataEntry withRenderType(RenderType renderType) {
        return new RenderDataEntry(renderType, renderType == RenderType.DEFAULT ? null : this.renderEntityType);
    }

    public RenderDataEntry withRenderEntityType(class_1299<? extends class_1297> renderEntityType) {
        return new RenderDataEntry(renderEntityType != null ? RenderType.CUSTOM_ENTITY : RenderType.DEFAULT, renderEntityType);
    }

    public RenderDataEntry create(class_2487 compoundTag) {
        return new RenderDataEntry(compoundTag);
    }

    public class_2487 write(class_2487 compoundTag) {
        if (this.renderType != RenderType.DEFAULT) {
            compoundTag.method_10582(DATA_RENDER_TYPE_TAG, this.renderType.name());
        }
        if (this.renderEntityType != null && this.renderEntityType.method_5893()) {
            class_2960 entityTypeResourceLocation = class_1299.method_5890(this.renderEntityType);
            compoundTag.method_10582(DATA_RENDER_ENTITY_TYPE_TAG, entityTypeResourceLocation.toString());
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.write(new class_2487());
    }

    public class_2487 save(class_2487 compoundTag) {
        return this.write(compoundTag);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public class_1299<? extends class_1297> getRenderEntityType() {
        return this.renderEntityType;
    }
}

