/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.saveddata;

import de.markusbordihn.easynpc.data.execution.ExecutionData;
import de.markusbordihn.easynpc.data.execution.ExecutionInterval;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionExecutionTracker
extends class_18 {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DATA_NAME = "easy_npc_action_executions";
    private static final String DATA_PLAYERS_TAG = "Players";
    private static final String DATA_PLAYER_UUID_TAG = "PlayerUUID";
    private static final String DATA_ACTIONS_TAG = "Actions";
    private static final String DATA_ACTION_UUID_TAG = "ActionUUID";
    private final Map<UUID, Map<UUID, ExecutionData>> trackingData = new HashMap<UUID, Map<UUID, ExecutionData>>();

    public static ActionExecutionTracker load(class_2487 compoundTag, class_7225.class_7874 provider) {
        ActionExecutionTracker tracker = new ActionExecutionTracker();
        class_2499 playersTag = compoundTag.method_10554(DATA_PLAYERS_TAG, 10);
        for (int i = 0; i < playersTag.size(); ++i) {
            class_2487 playerTag = playersTag.method_10602(i);
            HashMap<UUID, ExecutionData> playerData = new HashMap<UUID, ExecutionData>();
            class_2499 actionsTag = playerTag.method_10554(DATA_ACTIONS_TAG, 10);
            for (int j = 0; j < actionsTag.size(); ++j) {
                class_2487 actionTag = actionsTag.method_10602(j);
                UUID actionUUID = actionTag.method_25926(DATA_ACTION_UUID_TAG);
                playerData.put(actionUUID, new ExecutionData(actionTag));
            }
            tracker.trackingData.put(playerTag.method_25926(DATA_PLAYER_UUID_TAG), playerData);
        }
        return tracker;
    }

    public static ActionExecutionTracker get(class_3218 serverLevel) {
        return (ActionExecutionTracker)serverLevel.method_17983().method_17924(new class_18.class_8645(ActionExecutionTracker::new, ActionExecutionTracker::load, null), DATA_NAME);
    }

    public boolean canExecute(UUID playerUUID, UUID actionUUID, int limit, ExecutionInterval interval) {
        if (limit == 0) {
            return true;
        }
        ExecutionData data = (ExecutionData)((Map)this.trackingData.getOrDefault(playerUUID, new HashMap())).get(actionUUID);
        if (data == null) {
            return true;
        }
        if (interval == ExecutionInterval.LIFETIME) {
            return data.executionCount() < limit;
        }
        if (interval.hasIntervalPassed(data.windowStartTime())) {
            return true;
        }
        return data.executionCount() < limit;
    }

    public void recordExecution(UUID playerUUID, UUID actionUUID, ExecutionInterval interval) {
        Map playerData = this.trackingData.computeIfAbsent(playerUUID, k -> new HashMap());
        ExecutionData currentData = (ExecutionData)playerData.get(actionUUID);
        long now = System.currentTimeMillis();
        if (currentData == null || interval.hasIntervalPassed(currentData.windowStartTime())) {
            playerData.put(actionUUID, new ExecutionData(1, now, now));
            log.debug("Started new execution window for player {} action {} with interval {}", (Object)playerUUID, (Object)actionUUID, (Object)interval);
        } else {
            playerData.put(actionUUID, new ExecutionData(currentData.executionCount() + 1, currentData.windowStartTime(), now));
            log.debug("Recorded execution {} for player {} action {}", (Object)(currentData.executionCount() + 1), (Object)playerUUID, (Object)actionUUID);
        }
        this.method_80();
    }

    public void resetExecution(UUID playerUUID, UUID actionUUID) {
        Map<UUID, ExecutionData> playerData = this.trackingData.get(playerUUID);
        if (playerData != null && playerData.remove(actionUUID) != null) {
            log.debug("Reset execution for player {} action {}", (Object)playerUUID, (Object)actionUUID);
            this.method_80();
        }
    }

    public void resetExecutionForAllPlayers(UUID actionUUID) {
        int resetCount = 0;
        for (Map<UUID, ExecutionData> playerData : this.trackingData.values()) {
            if (playerData.remove(actionUUID) == null) continue;
            ++resetCount;
        }
        if (resetCount > 0) {
            log.debug("Reset execution for {} players for action {}", (Object)resetCount, (Object)actionUUID);
            this.method_80();
        }
    }

    public void cleanupExpiredRecords() {
        long cutoffTime = System.currentTimeMillis() - ExecutionInterval.PER_MONTH.getMilliseconds();
        int removedCount = 0;
        for (Map<UUID, ExecutionData> playerData : this.trackingData.values()) {
            int beforeSize = playerData.size();
            playerData.entrySet().removeIf(entry -> ((ExecutionData)entry.getValue()).lastExecutionTime() < cutoffTime);
            removedCount += beforeSize - playerData.size();
        }
        this.trackingData.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        if (removedCount > 0) {
            log.debug("Cleaned up {} expired execution records", (Object)removedCount);
            this.method_80();
        }
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2499 playersTag = new class_2499();
        for (Map.Entry<UUID, Map<UUID, ExecutionData>> playerEntry : this.trackingData.entrySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_25927(DATA_PLAYER_UUID_TAG, playerEntry.getKey());
            class_2499 actionsTag = new class_2499();
            for (Map.Entry<UUID, ExecutionData> actionEntry : playerEntry.getValue().entrySet()) {
                class_2487 actionTag = new class_2487();
                actionTag.method_25927(DATA_ACTION_UUID_TAG, actionEntry.getKey());
                actionEntry.getValue().save(actionTag);
                actionsTag.add((Object)actionTag);
            }
            playerTag.method_10566(DATA_ACTIONS_TAG, (class_2520)actionsTag);
            playersTag.add((Object)playerTag);
        }
        compoundTag.method_10566(DATA_PLAYERS_TAG, (class_2520)playersTag);
        return compoundTag;
    }
}

