/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.saveddata;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.npc.NPCEntityMetadata;
import de.markusbordihn.easynpc.data.npc.SavedNPCEntityEntry;
import de.markusbordihn.easynpc.data.storage.NPCFileStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NPCEntityData
extends class_18 {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DATA_NAME = "easy_npc_index";
    private static final String DATA_METADATA_TAG = "Metadata";
    private static final String DATA_METADATA_UUID_TAG = "UUID";
    private static final String DATA_METADATA_DATA_TAG = "Data";
    private final Map<UUID, NPCEntityMetadata> metadata = new HashMap<UUID, NPCEntityMetadata>();
    private final Map<UUID, Set<UUID>> entriesByOwner = new HashMap<UUID, Set<UUID>>();
    private final Map<String, Set<UUID>> entriesByType = new HashMap<String, Set<UUID>>();
    private final Map<String, Set<UUID>> entriesByDimension = new HashMap<String, Set<UUID>>();
    private final Map<UUID, Set<UUID>> entriesByPreset = new HashMap<UUID, Set<UUID>>();
    private final Map<class_2960, Set<UUID>> entriesByCustomIdentifier = new HashMap<class_2960, Set<UUID>>();
    private final Map<String, Set<UUID>> entriesByCustomIdentifierNamespace = new HashMap<String, Set<UUID>>();
    private NPCFileStorage npcFileStorage;

    public static NPCEntityData load(class_2487 compoundTag, class_7225.class_7874 provider) {
        NPCEntityData data = new NPCEntityData();
        class_2499 metadataTag = compoundTag.method_10554(DATA_METADATA_TAG, 10);
        for (int i = 0; i < metadataTag.size(); ++i) {
            class_2487 entryTag = metadataTag.method_10602(i);
            UUID uuid = entryTag.method_25926(DATA_METADATA_UUID_TAG);
            NPCEntityMetadata meta = NPCEntityMetadata.fromCompoundTag(entryTag.method_10562(DATA_METADATA_DATA_TAG));
            if (uuid == null || meta == null) continue;
            data.metadata.put(uuid, meta);
            data.updateCachedMaps(uuid, meta);
        }
        log.info("Loaded metadata for {} NPC entities from index", (Object)data.metadata.size());
        return data;
    }

    public static NPCEntityData get(MinecraftServer server) {
        if (server == null) {
            log.error("Cannot get NPCEntityData: MinecraftServer is null");
            throw new IllegalArgumentException("MinecraftServer cannot be null");
        }
        if (server.method_30002() == null) {
            log.error("Cannot get NPCEntityData: Overworld is not yet loaded");
            throw new IllegalStateException("Overworld must be loaded before accessing NPCEntityData");
        }
        NPCEntityData data = (NPCEntityData)server.method_30002().method_17983().method_17924(new class_18.class_8645(NPCEntityData::new, NPCEntityData::load, null), DATA_NAME);
        if (data.npcFileStorage == null) {
            data.npcFileStorage = new NPCFileStorage(Constants.WORLD_DIR);
        }
        return data;
    }

    public void putEntry(UUID uuid, SavedNPCEntityEntry entry) {
        if (uuid == null || entry == null) {
            log.warn("Attempted to put null UUID or entry");
            return;
        }
        NPCEntityMetadata oldMetadata = this.metadata.get(uuid);
        if (oldMetadata != null) {
            this.removeCachedMaps(uuid, oldMetadata);
        }
        this.metadata.put(uuid, entry.metadata());
        this.updateCachedMaps(uuid, entry.metadata());
        this.method_80();
        if (this.npcFileStorage != null && entry.npcData() != null) {
            this.npcFileStorage.markDirty(uuid, entry.npcData());
        }
    }

    public void removeEntry(UUID uuid) {
        if (uuid == null) {
            return;
        }
        NPCEntityMetadata meta = this.metadata.remove(uuid);
        if (meta != null) {
            this.removeCachedMaps(uuid, meta);
            this.method_80();
        }
        if (this.npcFileStorage != null) {
            this.npcFileStorage.delete(uuid);
        }
    }

    public Optional<SavedNPCEntityEntry> getEntry(UUID uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        NPCEntityMetadata meta = this.metadata.get(uuid);
        if (meta == null) {
            return Optional.empty();
        }
        if (this.npcFileStorage == null) {
            log.error("NPCFileStorage not initialized");
            return Optional.empty();
        }
        Optional<class_2487> npcData = this.npcFileStorage.load(uuid);
        if (npcData.isEmpty()) {
            log.warn("NPC file missing for UUID {}, removing from index", (Object)uuid);
            this.metadata.remove(uuid);
            this.removeCachedMaps(uuid, meta);
            this.method_80();
            return Optional.empty();
        }
        return Optional.of(new SavedNPCEntityEntry(uuid, npcData.get(), meta));
    }

    public Collection<SavedNPCEntityEntry> getAllEntries() {
        if (this.npcFileStorage == null) {
            log.error("NPCFileStorage not initialized");
            return Collections.emptyList();
        }
        return this.metadata.keySet().stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public int getCount() {
        return this.metadata.size();
    }

    public Set<String> getAllEntityTypes() {
        return Collections.unmodifiableSet(this.entriesByType.keySet());
    }

    public Set<String> getAllDimensions() {
        return Collections.unmodifiableSet(this.entriesByDimension.keySet());
    }

    public Set<class_2960> getAllCustomIdentifiers() {
        return Collections.unmodifiableSet(this.entriesByCustomIdentifier.keySet());
    }

    public Set<String> getAllCustomIdentifierNamespaces() {
        return Collections.unmodifiableSet(this.entriesByCustomIdentifierNamespace.keySet());
    }

    public Collection<SavedNPCEntityEntry> getEntriesByOwner(UUID ownerUUID) {
        if (ownerUUID == null) {
            return Collections.emptyList();
        }
        Set<UUID> entityUUIDs = this.entriesByOwner.get(ownerUUID);
        if (entityUUIDs == null || entityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return entityUUIDs.stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Collection<SavedNPCEntityEntry> getEntriesByType(String type) {
        if (type == null) {
            return Collections.emptyList();
        }
        Set<UUID> entityUUIDs = this.entriesByType.get(type);
        if (entityUUIDs == null || entityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return entityUUIDs.stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Collection<SavedNPCEntityEntry> getEntriesByDimension(String dimension) {
        if (dimension == null) {
            return Collections.emptyList();
        }
        Set<UUID> entityUUIDs = this.entriesByDimension.get(dimension);
        if (entityUUIDs == null || entityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return entityUUIDs.stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Collection<SavedNPCEntityEntry> getEntriesByPreset(UUID presetUUID) {
        if (presetUUID == null) {
            return Collections.emptyList();
        }
        Set<UUID> entityUUIDs = this.entriesByPreset.get(presetUUID);
        if (entityUUIDs == null || entityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return entityUUIDs.stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Collection<SavedNPCEntityEntry> getEntriesByCustomIdentifier(class_2960 customIdentifier) {
        if (customIdentifier == null) {
            return Collections.emptyList();
        }
        Set<UUID> entityUUIDs = this.entriesByCustomIdentifier.get(customIdentifier);
        if (entityUUIDs == null || entityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return entityUUIDs.stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Collection<SavedNPCEntityEntry> getEntriesByCustomIdentifierNamespace(String namespace) {
        if (namespace == null) {
            return Collections.emptyList();
        }
        Set<UUID> entityUUIDs = this.entriesByCustomIdentifierNamespace.get(namespace);
        if (entityUUIDs == null || entityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return entityUUIDs.stream().map(this::getEntry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private void updateCachedMaps(UUID entityUUID, NPCEntityMetadata meta) {
        if (meta == null) {
            return;
        }
        if (meta.hasOwner()) {
            this.entriesByOwner.computeIfAbsent(meta.ownerUUID(), k -> new HashSet()).add(entityUUID);
        }
        if (meta.hasEntityType()) {
            this.entriesByType.computeIfAbsent(meta.entityType(), k -> new HashSet()).add(entityUUID);
        }
        if (meta.hasDimension()) {
            this.entriesByDimension.computeIfAbsent(meta.dimension(), k -> new HashSet()).add(entityUUID);
        }
        if (meta.hasPreset()) {
            this.entriesByPreset.computeIfAbsent(meta.presetUUID(), k -> new HashSet()).add(entityUUID);
        }
        if (meta.hasCustomIdentifier()) {
            class_2960 customIdentifier = meta.customIdentifier();
            this.entriesByCustomIdentifier.computeIfAbsent(customIdentifier, k -> new HashSet()).add(entityUUID);
            this.entriesByCustomIdentifierNamespace.computeIfAbsent(customIdentifier.method_12836(), k -> new HashSet()).add(entityUUID);
        }
    }

    private void removeCachedMaps(UUID entityUUID, NPCEntityMetadata meta) {
        Set<UUID> set;
        if (meta == null) {
            return;
        }
        if (meta.hasOwner() && (set = this.entriesByOwner.get(meta.ownerUUID())) != null) {
            set.remove(entityUUID);
            if (set.isEmpty()) {
                this.entriesByOwner.remove(meta.ownerUUID());
            }
        }
        if (meta.hasEntityType() && (set = this.entriesByType.get(meta.entityType())) != null) {
            set.remove(entityUUID);
            if (set.isEmpty()) {
                this.entriesByType.remove(meta.entityType());
            }
        }
        if (meta.hasDimension() && (set = this.entriesByDimension.get(meta.dimension())) != null) {
            set.remove(entityUUID);
            if (set.isEmpty()) {
                this.entriesByDimension.remove(meta.dimension());
            }
        }
        if (meta.hasPreset() && (set = this.entriesByPreset.get(meta.presetUUID())) != null) {
            set.remove(entityUUID);
            if (set.isEmpty()) {
                this.entriesByPreset.remove(meta.presetUUID());
            }
        }
        if (meta.hasCustomIdentifier()) {
            Set<UUID> namespaceSet;
            class_2960 customIdentifier = meta.customIdentifier();
            Set<UUID> set2 = this.entriesByCustomIdentifier.get(customIdentifier);
            if (set2 != null) {
                set2.remove(entityUUID);
                if (set2.isEmpty()) {
                    this.entriesByCustomIdentifier.remove(customIdentifier);
                }
            }
            if ((namespaceSet = this.entriesByCustomIdentifierNamespace.get(customIdentifier.method_12836())) != null) {
                namespaceSet.remove(entityUUID);
                if (namespaceSet.isEmpty()) {
                    this.entriesByCustomIdentifierNamespace.remove(customIdentifier.method_12836());
                }
            }
        }
    }

    public int saveAllDirtyNPCs() {
        if (this.npcFileStorage != null) {
            return this.npcFileStorage.saveAllDirty();
        }
        return 0;
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2499 metadataTag = new class_2499();
        for (Map.Entry<UUID, NPCEntityMetadata> entry : this.metadata.entrySet()) {
            class_2487 entryTag = new class_2487();
            entryTag.method_25927(DATA_METADATA_UUID_TAG, entry.getKey());
            entryTag.method_10566(DATA_METADATA_DATA_TAG, (class_2520)entry.getValue().toCompoundTag());
            metadataTag.add((Object)entryTag);
        }
        compoundTag.method_10566(DATA_METADATA_TAG, (class_2520)metadataTag);
        int savedFiles = this.saveAllDirtyNPCs();
        if (savedFiles > 0) {
            log.debug("Saved metadata for {} NPC entities to index and {} dirty NPC files", (Object)this.metadata.size(), (Object)savedFiles);
        } else {
            log.debug("Saved metadata for {} NPC entities to index (no dirty files)", (Object)this.metadata.size());
        }
        return compoundTag;
    }
}

