/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_3222;
import net.minecraft.class_9015;

public class ScoreboardData {
    private static final Pattern SCORE_PATTERN = Pattern.compile("@score\\(([a-zA-Z0-9_.-]+)\\)");
    private static final String SCORES_TAG = "Scores";
    private final Map<String, Integer> scores = new HashMap<String, Integer>();

    public ScoreboardData() {
    }

    public ScoreboardData(class_2487 compoundTag) {
        this();
        if (compoundTag != null && compoundTag.method_10545(SCORES_TAG)) {
            class_2487 scoresTag = compoundTag.method_10562(SCORES_TAG);
            for (String key : scoresTag.method_10541()) {
                this.scores.put(key, scoresTag.method_10550(key));
            }
        }
    }

    public ScoreboardData(class_3222 serverPlayer, Set<String> objectiveNames) {
        this();
        if (serverPlayer != null && objectiveNames != null) {
            class_269 scoreboard = serverPlayer.method_7327();
            for (String objectiveName : objectiveNames) {
                if (!ScoreboardData.isValidObjectiveName(objectiveName)) continue;
                this.scores.put(objectiveName, ScoreboardData.getScoreboardValue(scoreboard, serverPlayer, objectiveName));
            }
        }
    }

    public static Set<String> parseScoreMacros(String text) {
        HashSet<String> objectiveNames = new HashSet<String>();
        if (text == null || text.isEmpty()) {
            return objectiveNames;
        }
        Matcher matcher = SCORE_PATTERN.matcher(text);
        while (matcher.find()) {
            String objectiveName = matcher.group(1);
            if (!ScoreboardData.isValidObjectiveName(objectiveName)) continue;
            objectiveNames.add(objectiveName);
        }
        return objectiveNames;
    }

    private static boolean isValidObjectiveName(String objectiveName) {
        return objectiveName != null && !objectiveName.isEmpty() && objectiveName.length() <= 32 && objectiveName.matches("[a-zA-Z0-9_.-]+");
    }

    private static int getScoreboardValue(class_269 scoreboard, class_3222 player, String objectiveName) {
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective != null) {
            return scoreboard.method_1180((class_9015)player, objective).method_55409();
        }
        return 0;
    }

    public int getScore(String objectiveName) {
        return this.scores.getOrDefault(objectiveName, 0);
    }

    public boolean hasScore(String objectiveName) {
        return this.scores.containsKey(objectiveName);
    }

    public class_2487 createTag() {
        class_2487 compoundTag = new class_2487();
        if (!this.scores.isEmpty()) {
            class_2487 scoresTag = new class_2487();
            for (Map.Entry<String, Integer> entry : this.scores.entrySet()) {
                scoresTag.method_10569(entry.getKey(), entry.getValue().intValue());
            }
            compoundTag.method_10566(SCORES_TAG, (class_2520)scoresTag);
        }
        return compoundTag;
    }

    public String toString() {
        return "ScoreboardData{scores=" + String.valueOf(this.scores) + "}";
    }
}

