/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardData;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenDataInterface;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class AdditionalScreenData
implements AdditionalScreenDataInterface {
    private static final String ACTION_EVENT_DATA_TAG = "ActionEventData";
    private static final String ACTION_EVENT_TYPE_TAG = "ActionEventType";
    private static final String DIALOG_DATA_TAG = "DialogData";
    private static final String SCOREBOARD_DATA_TAG = "ScoreboardData";
    private final ActionEventSet actionEventSet;
    private final ActionEventType actionEventType;
    private final class_2487 data;
    private final DialogDataSet dialogDataSet;
    private final ScoreboardData scoreboardData;

    public AdditionalScreenData(class_2487 compoundTag) {
        this.actionEventSet = AdditionalScreenData.getActionEventSet(compoundTag);
        this.actionEventType = AdditionalScreenData.getActionEventType(compoundTag);
        this.dialogDataSet = AdditionalScreenData.getDialogDataSet(compoundTag);
        this.scoreboardData = AdditionalScreenData.getScoreboardData(compoundTag);
        this.data = compoundTag;
        this.data.method_10551(ACTION_EVENT_DATA_TAG);
        this.data.method_10551(ACTION_EVENT_TYPE_TAG);
        this.data.method_10551(DIALOG_DATA_TAG);
        this.data.method_10551(SCOREBOARD_DATA_TAG);
    }

    public static void addActionEventType(class_2487 compoundTag, ActionEventType actionEventType) {
        if (compoundTag == null || actionEventType == null) {
            return;
        }
        compoundTag.method_10582(ACTION_EVENT_TYPE_TAG, actionEventType.name());
    }

    public static ActionEventType getActionEventType(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasActionEventType(compoundTag)) {
            return ActionEventType.NONE;
        }
        return ActionEventType.get(compoundTag.method_10558(ACTION_EVENT_TYPE_TAG));
    }

    public static boolean hasActionEventType(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(ACTION_EVENT_TYPE_TAG);
    }

    public static void addActionEventSet(class_2487 compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCActionEventData() == null) {
            return;
        }
        compoundTag.method_10566(ACTION_EVENT_DATA_TAG, (class_2520)easyNPC.getEasyNPCActionEventData().getActionEventSet().createTag());
    }

    public static ActionEventSet getActionEventSet(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasActionEventSet(compoundTag)) {
            return new ActionEventSet();
        }
        return new ActionEventSet(compoundTag.method_10562(ACTION_EVENT_DATA_TAG));
    }

    public static boolean hasActionEventSet(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(ACTION_EVENT_DATA_TAG);
    }

    public static void addDialogDataSet(class_2487 compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        compoundTag.method_10566(DIALOG_DATA_TAG, (class_2520)easyNPC.getEasyNPCDialogData().getDialogDataSet().createTag());
    }

    public static DialogDataSet getDialogDataSet(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasDialogDataSet(compoundTag)) {
            return new DialogDataSet();
        }
        return new DialogDataSet(compoundTag.method_10562(DIALOG_DATA_TAG));
    }

    public static boolean hasDialogDataSet(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(DIALOG_DATA_TAG);
    }

    public static void addScoreboardData(class_2487 compoundTag, ScoreboardData scoreboardData) {
        if (compoundTag == null || scoreboardData == null) {
            return;
        }
        compoundTag.method_10566(SCOREBOARD_DATA_TAG, (class_2520)scoreboardData.createTag());
    }

    public static ScoreboardData getScoreboardData(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasScoreboardData(compoundTag)) {
            return new ScoreboardData();
        }
        return new ScoreboardData(compoundTag.method_10562(SCOREBOARD_DATA_TAG));
    }

    public static boolean hasScoreboardData(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(SCOREBOARD_DATA_TAG);
    }

    public static void addDialogDataSet(class_2487 compoundTag, EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        Set<String> objectiveNames;
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        compoundTag.method_10566(DIALOG_DATA_TAG, (class_2520)dialogDataSet.createTag());
        if (serverPlayer != null && !(objectiveNames = AdditionalScreenData.extractObjectiveNamesFromDialogDataSet(dialogDataSet)).isEmpty()) {
            ScoreboardData scoreboardData = new ScoreboardData(serverPlayer, objectiveNames);
            AdditionalScreenData.addScoreboardData(compoundTag, scoreboardData);
        }
    }

    private static Set<String> extractObjectiveNamesFromDialogDataSet(DialogDataSet dialogDataSet) {
        HashSet<String> objectiveNames = new HashSet<String>();
        if (dialogDataSet == null || !dialogDataSet.hasDialog()) {
            return objectiveNames;
        }
        for (DialogDataEntry dialogEntry : dialogDataSet.getDialogsByLabel()) {
            if (dialogEntry == null || dialogEntry.getDialogTexts() == null) continue;
            for (DialogTextData dialogTextData : dialogEntry.getDialogTexts()) {
                if (dialogTextData == null || dialogTextData.text() == null) continue;
                objectiveNames.addAll(ScoreboardData.parseScoreMacros(dialogTextData.text()));
            }
        }
        return objectiveNames;
    }

    @Override
    public ActionEventType getActionEventType() {
        return this.actionEventType;
    }

    @Override
    public ActionEventSet getActionEventSet() {
        return this.actionEventSet;
    }

    @Override
    public DialogDataSet getDialogDataSet() {
        return this.dialogDataSet;
    }

    @Override
    public class_2487 getData() {
        return this.data;
    }

    public class_2487 get(String dataTag) {
        if (this.data.method_10545(dataTag)) {
            return this.data.method_10562(dataTag);
        }
        return new class_2487();
    }

    public class_2499 getList(String dataTag) {
        if (this.data.method_10545(dataTag)) {
            return this.data.method_10554(dataTag, 10);
        }
        return new class_2499();
    }

    @Override
    public boolean hasDialogDataSet() {
        return this.dialogDataSet != null;
    }

    @Override
    public ScoreboardData getScoreboardData() {
        return this.scoreboardData;
    }
}

