/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.validator.UrlValidator;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SkinDataEntry(String name, String url, UUID uuid, SkinType type, boolean disableLayers, String content, long timestamp) {
    static final String DATA_NAME_TAG = "Name";
    static final String DATA_TYPE_TAG = "Type";
    static final String DATA_URL_TAG = "URL";
    static final String DATA_UUID_TAG = "UUID";
    static final String DATA_DISABLE_LAYERS_TAG = "DisableLayers";
    static final String DATA_CONTENT_TAG = "Content";
    static final String DATA_TIMESTAMP_TAG = "Timestamp";
    public static final class_9139<class_9129, SkinDataEntry> STREAM_CODEC = new class_9139<class_9129, SkinDataEntry>(){

        public SkinDataEntry decode(class_9129 registryFriendlyByteBuf) {
            return new SkinDataEntry(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, SkinDataEntry skinDataEntry) {
            registryFriendlyByteBuf.method_10794((class_2520)EntityDataSerializersManager.validateAndGetNbt(skinDataEntry.createTag(), "SkinDataEntry"));
        }
    };

    public SkinDataEntry() {
        this("", "", Constants.BLANK_UUID, SkinType.DEFAULT, false, "", System.currentTimeMillis());
    }

    public SkinDataEntry(String name, String url, UUID uuid, SkinType type) {
        this(name, url, uuid, type, false, "", System.currentTimeMillis());
    }

    public SkinDataEntry(class_2487 compoundTag) {
        this(compoundTag.method_10545(DATA_NAME_TAG) ? compoundTag.method_10558(DATA_NAME_TAG) : "", compoundTag.method_10545(DATA_URL_TAG) ? compoundTag.method_10558(DATA_URL_TAG) : "", compoundTag.method_10545(DATA_UUID_TAG) ? compoundTag.method_25926(DATA_UUID_TAG) : Constants.BLANK_UUID, SkinType.get(compoundTag.method_10558(DATA_TYPE_TAG)), compoundTag.method_10545(DATA_DISABLE_LAYERS_TAG) && compoundTag.method_10577(DATA_DISABLE_LAYERS_TAG), compoundTag.method_10545(DATA_CONTENT_TAG) ? compoundTag.method_10558(DATA_CONTENT_TAG) : "", compoundTag.method_10545(DATA_TIMESTAMP_TAG) ? compoundTag.method_10537(DATA_TIMESTAMP_TAG) : System.currentTimeMillis());
    }

    public static SkinDataEntry createNoneSkin() {
        return new SkinDataEntry("", "", Constants.BLANK_UUID, SkinType.NONE);
    }

    public static SkinDataEntry createDefaultSkin(String variantName) {
        return new SkinDataEntry(variantName, "", Constants.BLANK_UUID, SkinType.DEFAULT);
    }

    public static SkinDataEntry createCustomSkin(UUID skinUUID, boolean disableLayers) {
        return new SkinDataEntry("", "", skinUUID, SkinType.CUSTOM, disableLayers, "", System.currentTimeMillis());
    }

    public static SkinDataEntry createPlayerSkin(String playerName, UUID playerUUID) {
        return new SkinDataEntry(playerName, "", playerUUID, SkinType.PLAYER_SKIN);
    }

    public static SkinDataEntry createRemoteSkin(String skinURL) {
        return new SkinDataEntry("", skinURL, UUID.nameUUIDFromBytes(skinURL.getBytes()), UrlValidator.isSecureRemoteUrl(skinURL) ? SkinType.SECURE_REMOTE_URL : SkinType.INSECURE_REMOTE_URL);
    }

    public SkinDataEntry withName(String name) {
        return new SkinDataEntry(name, this.url, this.uuid, this.type, this.disableLayers, this.content, this.timestamp);
    }

    public SkinDataEntry withType(SkinType type) {
        return new SkinDataEntry(this.name, this.url, this.uuid, type, this.disableLayers, this.content, this.timestamp);
    }

    public SkinDataEntry withURL(String url) {
        return new SkinDataEntry(this.name, url, this.uuid, this.type, this.disableLayers, this.content, this.timestamp);
    }

    public SkinDataEntry withUUID(UUID uuid) {
        return new SkinDataEntry(this.name, this.url, uuid, this.type, this.disableLayers, this.content, this.timestamp);
    }

    public SkinDataEntry withDisableLayers(boolean disableLayers) {
        return new SkinDataEntry(this.name, this.url, this.uuid, this.type, disableLayers, this.content, this.timestamp);
    }

    public SkinDataEntry create(class_2487 compoundTag) {
        return new SkinDataEntry(compoundTag);
    }

    public class_2487 write(class_2487 compoundTag) {
        compoundTag.method_10582(DATA_NAME_TAG, this.name);
        compoundTag.method_10582(DATA_TYPE_TAG, this.type.name());
        compoundTag.method_10582(DATA_URL_TAG, this.url);
        compoundTag.method_25927(DATA_UUID_TAG, this.uuid);
        compoundTag.method_10556(DATA_DISABLE_LAYERS_TAG, this.disableLayers);
        compoundTag.method_10582(DATA_CONTENT_TAG, this.content);
        compoundTag.method_10544(DATA_TIMESTAMP_TAG, this.timestamp);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.write(new class_2487());
    }
}

