/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.status;

import java.util.Locale;

public enum StatusDataType {
    FINALIZED(ValueType.BOOLEAN),
    NPC_DATA_LAST_UPDATE(ValueType.TIMESTAMP),
    NPC_DATA_LAST_SAVED(ValueType.TIMESTAMP);

    private final ValueType valueType;

    private StatusDataType(ValueType valueType) {
        this.valueType = valueType;
    }

    public static StatusDataType get(String statusDataType) {
        if (statusDataType == null || statusDataType.isEmpty()) {
            return null;
        }
        try {
            return StatusDataType.valueOf(statusDataType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getTagName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isBoolean() {
        return this.valueType == ValueType.BOOLEAN;
    }

    public boolean isTimestamp() {
        return this.valueType == ValueType.TIMESTAMP;
    }

    public static enum ValueType {
        BOOLEAN,
        TIMESTAMP;

    }
}

