/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NPCFileStorage {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String NPCS_FOLDER = "npcs";
    private static final String NPC_FILE_EXTENSION = ".npc.nbt";
    private final Path storageFolder;
    private final Map<UUID, class_2487> cache = new ConcurrentHashMap<UUID, class_2487>();
    private final Map<UUID, class_2487> dirtyNPCs = new ConcurrentHashMap<UUID, class_2487>();

    public NPCFileStorage(Path worldPath) {
        this.storageFolder = worldPath.resolve("easy_npc").resolve(NPCS_FOLDER);
        this.ensureStorageFolderExists();
    }

    private void ensureStorageFolderExists() {
        try {
            if (!Files.exists(this.storageFolder, new LinkOption[0])) {
                Files.createDirectories(this.storageFolder, new FileAttribute[0]);
                log.info("Created NPC storage folder at {}", (Object)this.storageFolder);
            }
        }
        catch (IOException e) {
            log.error("Failed to create NPC storage folder at {}", (Object)this.storageFolder, (Object)e);
        }
    }

    public Path getNPCFilePath(UUID uuid) {
        return this.storageFolder.resolve(uuid.toString() + NPC_FILE_EXTENSION);
    }

    public boolean exists(UUID uuid) {
        return Files.exists(this.getNPCFilePath(uuid), new LinkOption[0]);
    }

    public Optional<class_2487> load(UUID uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        class_2487 cached = this.cache.get(uuid);
        if (cached != null) {
            return Optional.of(cached);
        }
        Path npcFile = this.getNPCFilePath(uuid);
        if (!Files.exists(npcFile, new LinkOption[0])) {
            log.debug("NPC file not found for UUID {}", (Object)uuid);
            return Optional.empty();
        }
        try {
            class_2487 data = class_2507.method_30613((Path)npcFile, (class_2505)class_2505.method_53898());
            this.cache.put(uuid, data);
            log.debug("Loaded NPC data for UUID {} from file {}", (Object)uuid, (Object)npcFile);
            return Optional.of(data);
        }
        catch (IOException e) {
            log.error("Failed to load NPC file {} for UUID {}", (Object)npcFile, (Object)uuid, (Object)e);
            return Optional.empty();
        }
    }

    public void markDirty(UUID uuid, class_2487 data) {
        if (uuid != null && data != null) {
            this.dirtyNPCs.put(uuid, data);
            this.cache.put(uuid, data);
        }
    }

    public boolean save(UUID uuid, class_2487 data) {
        if (uuid == null || data == null) {
            log.warn("Attempted to save null UUID or data");
            return false;
        }
        return this.saveToFile(uuid, data);
    }

    private boolean saveToFile(UUID uuid, class_2487 data) {
        Path npcFile = this.getNPCFilePath(uuid);
        try {
            Path tempFile = npcFile.getParent().resolve(uuid.toString() + ".tmp");
            class_2507.method_30614((class_2487)data, (Path)tempFile);
            Files.move(tempFile, npcFile, StandardCopyOption.REPLACE_EXISTING);
            this.cache.put(uuid, data);
            log.debug("Saved NPC data for UUID {} to file {}", (Object)uuid, (Object)npcFile);
            return true;
        }
        catch (IOException e) {
            log.error("Failed to save NPC file for UUID {}", (Object)uuid, (Object)e);
            return false;
        }
    }

    public int saveAllDirty() {
        HashMap<UUID, class_2487> snapshot = new HashMap<UUID, class_2487>(this.dirtyNPCs);
        int savedCount = 0;
        for (Map.Entry entry : snapshot.entrySet()) {
            if (!this.saveToFile((UUID)entry.getKey(), (class_2487)entry.getValue())) continue;
            this.dirtyNPCs.remove(entry.getKey(), entry.getValue());
            ++savedCount;
        }
        if (savedCount > 0) {
            log.info("Saved {} dirty NPC files out of {}", (Object)savedCount, (Object)snapshot.size());
        }
        return savedCount;
    }

    public int getDirtyCount() {
        return this.dirtyNPCs.size();
    }

    public boolean isDirty(UUID uuid) {
        return this.dirtyNPCs.containsKey(uuid);
    }

    public boolean delete(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        this.cache.remove(uuid);
        this.dirtyNPCs.remove(uuid);
        Path npcFile = this.getNPCFilePath(uuid);
        if (!Files.exists(npcFile, new LinkOption[0])) {
            return true;
        }
        try {
            Files.delete(npcFile);
            log.debug("Deleted NPC file for UUID {}", (Object)uuid);
            return true;
        }
        catch (IOException e) {
            log.error("Failed to delete NPC file for UUID {}", (Object)uuid, (Object)e);
            return false;
        }
    }

    public void clearCache() {
        this.cache.clear();
        log.debug("Cleared NPC file storage cache");
    }

    public void evictFromCache(UUID uuid) {
        this.cache.remove(uuid);
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public Stream<UUID> getAllStoredNPCUUIDs() {
        Stream<UUID> stream;
        block8: {
            Stream<Path> pathStream = Files.list(this.storageFolder);
            try {
                stream = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(NPC_FILE_EXTENSION)).map(path -> {
                    String fileName = path.getFileName().toString();
                    String uuidString = fileName.substring(0, fileName.length() - NPC_FILE_EXTENSION.length());
                    try {
                        return UUID.fromString(uuidString);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Invalid UUID in filename: {}", (Object)fileName);
                        return null;
                    }
                }).filter(Objects::nonNull).toList().stream();
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to list NPC files in storage folder", (Throwable)e);
                    return Stream.empty();
                }
            }
            pathStream.close();
        }
        return stream;
    }
}

