/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.api.npc.raw.skeleton.SkeletonRaw;
import de.markusbordihn.easynpc.api.npc.raw.skeleton.StrayRaw;
import de.markusbordihn.easynpc.api.npc.raw.skeleton.WitherSkeletonRaw;
import de.markusbordihn.easynpc.api.npc.raw.villager.VillagerRaw;
import de.markusbordihn.easynpc.api.npc.raw.zombie.ZombieRaw;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NPCEntityFactory {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<class_1299<?>, BiFunction<class_1299<?>, class_1937, class_1297>> entityConstructors = new HashMap();

    private NPCEntityFactory() {
    }

    public static class_1297 createEntityFromBaseType(class_1299<?> baseEntityType, class_1299<?> targetEntityType, class_1937 level) {
        BiFunction<class_1299<?>, class_1937, class_1297> constructor = entityConstructors.get(baseEntityType);
        if (constructor == null) {
            throw new IllegalArgumentException("Unsupported base entity type: " + NPCEntityFactory.getEntityTypeId(baseEntityType) + ". Supported types are: " + String.valueOf(NPCEntityFactory.getSupportedBaseTypeIds()));
        }
        try {
            class_1297 entity = constructor.apply(targetEntityType, level);
            if (entity == null) {
                throw new IllegalStateException("Constructor for base type " + NPCEntityFactory.getEntityTypeId(baseEntityType) + " returned null entity");
            }
            return entity;
        }
        catch (Exception e) {
            log.error("Failed to create entity from base type {}: {}", (Object)NPCEntityFactory.getEntityTypeId(baseEntityType), (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to create entity from base type " + NPCEntityFactory.getEntityTypeId(baseEntityType), e);
        }
    }

    public static boolean isBaseTypeSupported(class_1299<?> baseEntityType) {
        return entityConstructors.containsKey(baseEntityType);
    }

    public static String[] getSupportedBaseTypeIds() {
        return (String[])entityConstructors.keySet().stream().map(NPCEntityFactory::getEntityTypeId).toArray(String[]::new);
    }

    public static void registerEntityConstructor(class_1299<?> baseEntityType, BiFunction<class_1299<?>, class_1937, class_1297> constructor) {
        entityConstructors.put(baseEntityType, constructor);
        log.debug("Registered entity constructor for base type: {}", (Object)NPCEntityFactory.getEntityTypeId(baseEntityType));
    }

    private static void initializeEntityConstructors() {
        NPCEntityFactory.registerEntityConstructor(class_1299.field_6051, (type, level) -> new ZombieRaw((class_1299<? extends class_1642>)type, (class_1937)level));
        NPCEntityFactory.registerEntityConstructor(class_1299.field_6077, (type, level) -> new VillagerRaw((class_1299<? extends class_1646>)type, (class_1937)level));
        NPCEntityFactory.registerEntityConstructor(class_1299.field_6137, (type, level) -> new SkeletonRaw((class_1299<? extends class_1613>)type, (class_1937)level));
        NPCEntityFactory.registerEntityConstructor(class_1299.field_6098, (type, level) -> new StrayRaw((class_1299<? extends class_1627>)type, (class_1937)level));
        NPCEntityFactory.registerEntityConstructor(class_1299.field_6076, (type, level) -> new WitherSkeletonRaw((class_1299<? extends class_1639>)type, (class_1937)level));
    }

    private static String getEntityTypeId(class_1299<?> entityType) {
        class_2960 resourceLocation = class_7923.field_41177.method_10221(entityType);
        return resourceLocation.toString();
    }

    static {
        NPCEntityFactory.initializeEntityConstructors();
    }
}

