/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.data.npc.SavedNPCEntityEntry;
import de.markusbordihn.easynpc.data.saveddata.NPCEntityData;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NPCEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String LOG_PREFIX = "[NPC Entity Manager]";
    private static MinecraftServer currentServer;

    private NPCEntityManager() {
    }

    public static void initialize(MinecraftServer server) {
        if (server == null) {
            log.error("{} Cannot initialize with null server", (Object)LOG_PREFIX);
            return;
        }
        currentServer = server;
        NPCEntityData savedData = NPCEntityData.get(server);
        log.info("{} Initialized with {} tracked NPC entities", (Object)LOG_PREFIX, (Object)savedData.getCount());
    }

    public static <T extends class_1308> void saveNPC(EasyNPC<T> easyNPC) {
        if (!NPCEntityManager.validateServer() || easyNPC == null) {
            return;
        }
        easyNPC.getEasyNPCStatusData().markNPCDataUpdated();
        SavedNPCEntityEntry entry = SavedNPCEntityEntry.fromEasyNPC(easyNPC);
        if (entry != null) {
            NPCEntityManager.getNPCEntityData().putEntry(entry.entityUUID(), entry);
            easyNPC.getEasyNPCStatusData().markNPCDataSaved();
            log.debug("{} Saved NPC entity: {}", (Object)LOG_PREFIX, (Object)entry.entityUUID());
        }
    }

    public static void removeNPC(UUID entityUUID) {
        if (!NPCEntityManager.validateServer() || entityUUID == null) {
            return;
        }
        NPCEntityManager.getNPCEntityData().removeEntry(entityUUID);
        log.debug("{} Removed NPC entity: {}", (Object)LOG_PREFIX, (Object)entityUUID);
    }

    public static void saveAllDirtyNPCs() {
        if (!NPCEntityManager.validateServer()) {
            return;
        }
        int savedCount = 0;
        for (EasyNPC<?> easyNPC : LivingEntityManager.getNpcEntityMap().values()) {
            if (easyNPC == null || !easyNPC.getEasyNPCStatusData().hasUnsavedNPCData()) continue;
            NPCEntityManager.saveNPC(easyNPC);
            ++savedCount;
        }
        if (savedCount > 0) {
            log.info("{} Saved {} dirty NPC(s) to persistent storage", (Object)LOG_PREFIX, (Object)savedCount);
        }
    }

    public static Optional<SavedNPCEntityEntry> getNPC(UUID entityUUID) {
        if (!NPCEntityManager.validateServer() || entityUUID == null) {
            return Optional.empty();
        }
        return NPCEntityManager.getNPCEntityData().getEntry(entityUUID);
    }

    public static Collection<SavedNPCEntityEntry> getAllNPCs() {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getAllEntries();
    }

    public static int getCount() {
        if (!NPCEntityManager.validateServer()) {
            return 0;
        }
        return NPCEntityManager.getNPCEntityData().getCount();
    }

    public static Collection<SavedNPCEntityEntry> getNPCsByOwner(UUID ownerUUID) {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getEntriesByOwner(ownerUUID);
    }

    public static Collection<SavedNPCEntityEntry> getNPCsByType(String type) {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getEntriesByType(type);
    }

    public static Collection<SavedNPCEntityEntry> getNPCsByDimension(String dimension) {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getEntriesByDimension(dimension);
    }

    public static Collection<SavedNPCEntityEntry> getNPCsByPreset(UUID presetUUID) {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getEntriesByPreset(presetUUID);
    }

    public static Collection<SavedNPCEntityEntry> getNPCsByCustomIdentifier(class_2960 customIdentifier) {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getEntriesByCustomIdentifier(customIdentifier);
    }

    public static Collection<SavedNPCEntityEntry> getNPCsByCustomIdentifierNamespace(String namespace) {
        if (!NPCEntityManager.validateServer()) {
            return Collections.emptyList();
        }
        return NPCEntityManager.getNPCEntityData().getEntriesByCustomIdentifierNamespace(namespace);
    }

    private static boolean validateServer() {
        if (currentServer == null) {
            log.warn("{} Server not initialized", (Object)LOG_PREFIX);
            return false;
        }
        return true;
    }

    private static NPCEntityData getNPCEntityData() {
        return NPCEntityData.get(currentServer);
    }
}

