/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.control.JumpEasyNPCMoveControl;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_7;

public class FollowLivingEntityGoal
extends class_1352 {
    private static final int COMBAT_COOLDOWN_DURATION = 60;
    private final class_1308 mob;
    private final NavigationDataCapable<?> navigationData;
    private final class_1309 livingEntity;
    private final double speedModifier;
    private final float stopDistance;
    private final float startDistance;
    private final boolean canFly;
    private final boolean canJump;
    private final class_1408 pathNavigation;
    private final class_4538 level;
    private float oldWaterCost;
    private int timeToRecalcPath;
    private int combatCooldownTicks = 0;

    public FollowLivingEntityGoal(EasyNPC<?> easyNPC, class_1309 livingEntity, double speedModifier, float stopDistance, float startDistance) {
        this.mob = easyNPC.getMob();
        this.navigationData = easyNPC.getEasyNPCNavigationData();
        this.livingEntity = livingEntity;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.startDistance = startDistance;
        this.canFly = this.navigationData.canFly();
        this.canJump = this.navigationData.canJump();
        this.pathNavigation = this.mob.method_5942();
        this.level = easyNPC.getEntityServerLevel();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.mob.method_5968() != null) {
            this.combatCooldownTicks = 60;
            return false;
        }
        if (this.combatCooldownTicks > 0) {
            --this.combatCooldownTicks;
            return false;
        }
        double distanceSq = this.mob.method_5858((class_1297)this.livingEntity);
        return this.mob.method_5805() && this.livingEntity != null && this.livingEntity.method_5805() && distanceSq > (double)(this.stopDistance * this.stopDistance) && distanceSq < (double)(this.startDistance * this.startDistance);
    }

    public boolean method_6266() {
        if (this.mob.method_5968() != null) {
            this.combatCooldownTicks = 60;
            return false;
        }
        if (this.combatCooldownTicks > 0) {
            --this.combatCooldownTicks;
            return false;
        }
        return !this.pathNavigation.method_6357() && this.mob.method_5858((class_1297)this.livingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        class_1308 class_13082 = this.mob;
        if (class_13082 instanceof class_1314) {
            class_1314 pathfinderMob = (class_1314)class_13082;
            this.oldWaterCost = pathfinderMob.method_5944(class_7.field_18);
            pathfinderMob.method_5941(class_7.field_18, 0.0f);
        }
    }

    public void method_6270() {
        this.pathNavigation.method_6340();
        class_1308 class_13082 = this.mob;
        if (class_13082 instanceof class_1314) {
            class_1314 pathfinderMob = (class_1314)class_13082;
            pathfinderMob.method_5941(class_7.field_18, this.oldWaterCost);
        }
    }

    public void method_6268() {
        this.mob.method_5988().method_6226((class_1297)this.livingEntity, 10.0f, (float)this.mob.method_5978());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.method_38847(10);
            if (!this.mob.method_60953() && !this.mob.method_5765()) {
                class_1335 class_13352;
                if (this.mob.method_5858((class_1297)this.livingEntity) >= 144.0) {
                    this.teleportToLivingEntity();
                } else if (this.canJump && (class_13352 = this.mob.method_5962()) instanceof JumpEasyNPCMoveControl) {
                    JumpEasyNPCMoveControl jumpMoveControl = (JumpEasyNPCMoveControl)class_13352;
                    double dx = this.livingEntity.method_23317() - this.mob.method_23317();
                    double dz = this.livingEntity.method_23321() - this.mob.method_23321();
                    jumpMoveControl.setDirection((float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f, false);
                    jumpMoveControl.setWantedMovement(this.speedModifier);
                } else {
                    this.pathNavigation.method_6335((class_1297)this.livingEntity, this.speedModifier);
                }
            }
        }
    }

    private void teleportToLivingEntity() {
        class_2338 blockPos = this.livingEntity.method_24515();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int posX, int posY, int posZ) {
        if (Math.abs((double)posX - this.livingEntity.method_23317()) < 2.0 && Math.abs((double)posZ - this.livingEntity.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(posX, posY, posZ))) {
            return false;
        }
        this.mob.method_5808((double)posX + 0.5, (double)posY, (double)posZ + 0.5, this.mob.method_36454(), this.mob.method_36455());
        this.pathNavigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 blockPos) {
        class_7 blockPathTypes = class_14.method_57625((class_1308)this.mob, (class_2338)blockPos.method_25503());
        if (!this.canFly && blockPathTypes != class_7.field_12) {
            return false;
        }
        class_2680 blockState = this.level.method_8320(blockPos.method_10074());
        if (!this.canFly && blockState.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 targetBlockPos = blockPos.method_10059((class_2382)this.mob.method_24515());
        return this.level.method_8587((class_1297)this.mob, this.mob.method_5829().method_996(targetBlockPos));
    }

    private int randomIntInclusive(int fromRange, int toRange) {
        return this.mob.method_59922().method_43048(toRange - fromRange + 1) + fromRange;
    }
}

