/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.control.JumpEasyNPCMoveControl;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5532;

public class MoveBackToHomeGoal<T extends EasyNPC<?>>
extends class_1352 {
    private final float stopDistance;
    private final NavigationDataCapable<?> navigationData;
    private final class_1308 mob;
    private final class_1314 pathfinderMob;
    private final double speedModifier;
    private final int interval;
    private final boolean canJump;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public MoveBackToHomeGoal(T easyNPCEntity, double speedModifier, float stopDistance) {
        this(easyNPCEntity, speedModifier, stopDistance, 240);
    }

    public MoveBackToHomeGoal(T easyNPCEntity, double speedModifier, float stopDistance, int interval) {
        this.stopDistance = stopDistance;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
        this.mob = easyNPCEntity.getMob();
        this.pathfinderMob = easyNPCEntity.getPathfinderMob();
        this.canJump = this.navigationData.canJump();
    }

    public boolean method_6264() {
        if (this.mob.method_5782() || this.mob.method_59922().method_43048(MoveBackToHomeGoal.method_38848((int)this.interval)) != 0 || this.mob.method_6510() && this.mob.method_5968() != null || this.reachedHome()) {
            return false;
        }
        class_243 vec3 = this.getPosition();
        if (vec3 == null) {
            return false;
        }
        class_2338 blockPos = this.navigationData.getHomePosition();
        this.wantedX = blockPos.method_10263();
        this.wantedY = blockPos.method_10264();
        this.wantedZ = blockPos.method_10260();
        return true;
    }

    public boolean method_6266() {
        return !this.mob.method_5942().method_6357() && !this.mob.method_5782() && this.mob.method_5968() == null;
    }

    public void method_6269() {
        class_1335 class_13352;
        if (this.canJump && (class_13352 = this.mob.method_5962()) instanceof JumpEasyNPCMoveControl) {
            JumpEasyNPCMoveControl jumpMoveControl = (JumpEasyNPCMoveControl)class_13352;
            double dx = this.wantedX - this.mob.method_23317();
            double dz = this.wantedZ - this.mob.method_23321();
            jumpMoveControl.setDirection((float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f, false);
            jumpMoveControl.setWantedMovement(this.speedModifier);
        } else {
            this.mob.method_5942().method_6337(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
        super.method_6270();
    }

    private class_243 getPosition() {
        class_4076 homePosition;
        if (this.reachedHome()) {
            return null;
        }
        class_4076 currentPosition = class_4076.method_18682((class_2338)this.mob.method_24515());
        if (currentPosition != (homePosition = class_4076.method_18682((class_2338)this.navigationData.getHomePosition())) && this.pathfinderMob != null) {
            return class_5532.method_31512((class_1314)this.pathfinderMob, (int)10, (int)7, (class_243)class_243.method_24955((class_2382)homePosition), (double)1.5707963705062866);
        }
        return null;
    }

    private boolean reachedHome() {
        if (this.navigationData == null) {
            return true;
        }
        if (!this.navigationData.hasHomePosition()) {
            return this.navigationData.getGroundPathNavigation().method_6357();
        }
        if (this.mob.method_24515().equals((Object)this.navigationData.getHomePosition())) {
            return true;
        }
        class_2338 blockPos = this.mob.method_24515();
        class_2382 vec3i = new class_2382(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        return this.navigationData.getHomePosition().method_19771(vec3i, (double)this.stopDistance);
    }
}

