/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.control.JumpEasyNPCMoveControl;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import java.util.EnumSet;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5531;
import net.minecraft.class_5534;
import net.minecraft.class_5819;

public class RandomStrollAroundHomeGoal<T extends EasyNPC<?>>
extends class_1352 {
    private final NavigationDataCapable<?> navigationData;
    private final class_1308 mob;
    private final class_1314 pathfinderMob;
    private final double speedModifier;
    private final int interval;

    public RandomStrollAroundHomeGoal(T easyNPCEntity, double speedModifier) {
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
        this.mob = easyNPCEntity.getMob();
        this.pathfinderMob = easyNPCEntity.getPathfinderMob();
        this.speedModifier = speedModifier;
        this.interval = 240;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        double dz;
        double dy;
        if (this.mob.method_5782() || !this.navigationData.hasHomePosition() || this.mob.method_59922().method_43048(RandomStrollAroundHomeGoal.method_38848((int)this.interval)) != 0) {
            return false;
        }
        if (this.pathfinderMob != null) {
            class_243 vec3 = this.getPosition();
            if (vec3 == null) {
                return false;
            }
            return this.pathfinderMob.method_5942().method_6337(vec3.field_1352, vec3.field_1351, vec3.field_1350, this.speedModifier);
        }
        class_1335 moveControl = this.mob.method_5962();
        if (!moveControl.method_6241()) {
            return true;
        }
        double dx = moveControl.method_6236() - this.mob.method_23317();
        double distanceSq = dx * dx + (dy = moveControl.method_6235() - this.mob.method_23318()) * dy + (dz = moveControl.method_6237() - this.mob.method_23321()) * dz;
        return distanceSq < 1.0 || distanceSq > 3600.0;
    }

    public boolean method_6266() {
        if (this.pathfinderMob != null) {
            return !this.pathfinderMob.method_5942().method_6357() && !this.pathfinderMob.method_5782() && (!this.pathfinderMob.method_6510() || this.pathfinderMob.method_5968() == null);
        }
        return false;
    }

    public void method_6269() {
        if (this.pathfinderMob == null) {
            double z;
            double y;
            double x;
            class_2338 homePos = this.navigationData.getHomePosition();
            class_5819 random = this.mob.method_59922();
            if (random.method_43057() < 0.5f) {
                double dz;
                double dy;
                double dx = (double)homePos.method_10263() - this.mob.method_23317();
                double distance = Math.sqrt(dx * dx + (dy = (double)homePos.method_10264() - this.mob.method_23318()) * dy + (dz = (double)homePos.method_10260() - this.mob.method_23321()) * dz);
                if (distance > 1.0) {
                    double factor = Math.min(10.0 / distance, 1.0) * (0.5 + random.method_43058() * 0.5);
                    x = this.mob.method_23317() + dx * factor + (random.method_43058() * 2.0 - 1.0) * 3.0;
                    y = this.mob.method_23318() + dy * factor + (random.method_43058() * 2.0 - 1.0) * 3.0;
                    z = this.mob.method_23321() + dz * factor + (random.method_43058() * 2.0 - 1.0) * 3.0;
                } else {
                    x = this.mob.method_23317() + (double)((random.method_43057() * 2.0f - 1.0f) * 10.0f);
                    y = this.mob.method_23318() + (double)((random.method_43057() * 2.0f - 1.0f) * 5.0f);
                    z = this.mob.method_23321() + (double)((random.method_43057() * 2.0f - 1.0f) * 10.0f);
                }
            } else {
                x = this.mob.method_23317() + (double)((random.method_43057() * 2.0f - 1.0f) * 10.0f);
                y = this.mob.method_23318() + (double)((random.method_43057() * 2.0f - 1.0f) * 5.0f);
                z = this.mob.method_23321() + (double)((random.method_43057() * 2.0f - 1.0f) * 10.0f);
            }
            class_1335 moveControl = this.mob.method_5962();
            if (moveControl instanceof JumpEasyNPCMoveControl) {
                JumpEasyNPCMoveControl jumpMoveControl = (JumpEasyNPCMoveControl)moveControl;
                jumpMoveControl.setDirection((float)(class_3532.method_15349((double)(z - this.mob.method_23321()), (double)(x - this.mob.method_23317())) * 57.29577951308232) - 90.0f, false);
                jumpMoveControl.setWantedMovement(this.speedModifier);
            } else {
                moveControl.method_6239(x, y, z, this.speedModifier);
            }
        }
    }

    public void method_6270() {
        if (this.pathfinderMob != null) {
            this.pathfinderMob.method_5942().method_6340();
        }
    }

    protected class_243 getPosition() {
        if (this.pathfinderMob.method_37908().field_9229.method_43057() < 0.5f) {
            return this.getPositionTowardsAnywhere();
        }
        class_243 targetPosition = this.getPositionTowardsHome();
        return targetPosition == null ? this.getPositionTowardsAnywhere() : targetPosition;
    }

    protected class_243 getPositionTowardsHome() {
        class_2338 homeBlockPos = this.navigationData.getHomePosition();
        class_243 homePosition = new class_243((double)homeBlockPos.method_10263(), (double)homeBlockPos.method_10264(), (double)homeBlockPos.method_10260());
        if (this.navigationData.isFlying()) {
            class_2338 blockPos = this.pathfinderMob.method_24515();
            int homePositionDifference = (int)(homePosition.field_1351 - (double)blockPos.method_10264());
            int flyingZ = 0;
            if (homePositionDifference > 2) {
                flyingZ = 4;
            } else if (homePositionDifference < -2) {
                flyingZ = -4;
            }
            int flyingX = 6;
            int flyingY = 8;
            int distanceToHome = blockPos.method_19455((class_2382)homeBlockPos);
            if (distanceToHome < 15) {
                flyingX = distanceToHome / 2;
                flyingY = distanceToHome / 2;
            }
            return class_5531.method_31508((class_1314)this.pathfinderMob, (int)flyingX, (int)flyingY, (int)flyingZ, (class_243)homePosition, (double)1.5707963705062866);
        }
        return class_5534.method_31528((class_1314)this.pathfinderMob, (int)10, (int)7, (class_243)homePosition);
    }

    private class_243 getPositionTowardsAnywhere() {
        return class_5534.method_31527((class_1314)this.pathfinderMob, (int)10, (int)7);
    }
}

