/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;

public interface ActionEventDataCapable<E extends class_1308>
extends EasyNPC<E> {
    public static final ServerDataAccessor<ActionEventSet> CUSTOM_DATA_ACTION_EVENT_SET = ServerEntityData.defineId(ServerDataIndex.ACTION_EVENT_SET, EntityDataSerializersManager.ACTION_EVENT_SET);
    public static final ServerDataAccessor<Integer> CUSTOM_DATA_ACTION_PERMISSION_LEVEL = ServerEntityData.defineId(ServerDataIndex.ACTION_PERMISSION_LEVEL, class_2943.field_13327);
    public static final String DATA_ACTION_DATA_TAG = "ActionData";
    public static final String DATA_ACTION_PERMISSION_LEVEL_TAG = "ActionPermissionLevel";

    default public ActionEventSet getActionEventSet() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET);
    }

    default public void setActionEventSet(ActionEventSet actions) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET, actions);
    }

    default public boolean hasActionEvent(ActionEventType actionEventType) {
        return actionEventType != null && this.getActionEventSet() != null && this.getActionEventSet().hasActionEvent(actionEventType);
    }

    default public ActionDataSet getActionDataSet(ActionEventType actionEventType) {
        return this.hasActionEvent(actionEventType) ? this.getActionEventSet().getActionEvents(actionEventType) : null;
    }

    default public boolean hasActionEventSet() {
        return this.getActionEventSet() != null;
    }

    default public void clearActionEventSet() {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET, new ActionEventSet());
    }

    default public int getActionPermissionLevel() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_ACTION_PERMISSION_LEVEL);
    }

    default public void setActionPermissionLevel(int actionPermissionLevel) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_ACTION_PERMISSION_LEVEL, actionPermissionLevel);
    }

    default public void defineSynchedActionData(class_2945.class_9222 builder) {
    }

    default public void defineCustomActionData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_ACTION_EVENT_SET, new ActionEventSet());
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_ACTION_PERMISSION_LEVEL, 0);
    }

    default public void addAdditionalActionData(class_2487 compoundTag) {
        class_2487 actionDataTag = new class_2487();
        if (this.isServerSideInstance()) {
            ActionEventSet actionEventSet = this.getActionEventSet();
            if (actionEventSet != null) {
                actionEventSet.save(actionDataTag);
            }
            actionDataTag.method_10569(DATA_ACTION_PERMISSION_LEVEL_TAG, this.getActionPermissionLevel());
        }
        compoundTag.method_10566(DATA_ACTION_DATA_TAG, (class_2520)actionDataTag);
    }

    default public void readAdditionalActionData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_ACTION_DATA_TAG)) {
            return;
        }
        class_2487 actionDataTag = compoundTag.method_10562(DATA_ACTION_DATA_TAG);
        if (actionDataTag.method_10545("ActionEventSet")) {
            ActionEventSet actionDataSet = new ActionEventSet(actionDataTag);
            this.setActionEventSet(actionDataSet);
        }
        if (actionDataTag.method_10545(DATA_ACTION_PERMISSION_LEVEL_TAG)) {
            this.setActionPermissionLevel(actionDataTag.method_10550(DATA_ACTION_PERMISSION_LEVEL_TAG));
        }
    }

    default public void registerDefaultActionInteractionEvents() {
        log.info("Register default action interaction events for {} ...", (Object)this);
        ActionEventSet actionEventSet = this.hasActionEventSet() ? this.getActionEventSet() : new ActionEventSet();
        ActionDataSet actionDataSet = actionEventSet.hasActionEvent(ActionEventType.ON_INTERACTION) ? actionEventSet.getActionEvents(ActionEventType.ON_INTERACTION) : new ActionDataSet();
        ActionDataEntry actionDataEntryOpenDialog = new ActionDataEntry(ActionDataType.OPEN_DEFAULT_DIALOG);
        actionDataSet.add(actionDataEntryOpenDialog);
        ActionDataEntry actionDataEntryOpenTradingScreen = new ActionDataEntry(ActionDataType.OPEN_TRADING_SCREEN);
        actionDataSet.add(actionDataEntryOpenTradingScreen);
        actionEventSet.setActionEvent(ActionEventType.ON_INTERACTION, actionDataSet);
        this.setActionEventSet(actionEventSet);
    }

    default public void handleActionEvent(ActionEventType actionEventType) {
        if (!this.hasActionEvent(actionEventType)) {
            return;
        }
        ActionHandler actionHandler = this.getEasyNPCActionHandler();
        if (actionHandler != null) {
            actionHandler.executeActions(this.getActionDataSet(actionEventType), null);
        }
    }

    default public void handleActionEvent(ActionEventType actionEventType, class_3222 serverPlayer) {
        if (!this.hasActionEvent(actionEventType)) {
            return;
        }
        ActionHandler actionHandler = this.getEasyNPCActionHandler();
        if (actionHandler != null) {
            actionHandler.executeActions(this.getActionDataSet(actionEventType), serverPlayer);
        }
    }
}

