/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_3222;

public interface DialogDataCapable<T extends class_1308>
extends EasyNPC<T> {
    public static final ServerDataAccessor<DialogDataSet> CUSTOM_DATA_DIALOG_DATA_SET = ServerEntityData.defineId(ServerDataIndex.DIALOG_DATA_SET, EntityDataSerializersManager.DIALOG_DATA_SET);
    public static final String DATA_DIALOG_DATA_TAG = "DialogData";

    default public int getEntityDialogTop() {
        return 0;
    }

    default public int getEntityDialogLeft() {
        return 0;
    }

    default public int getEntityDialogScaling() {
        return 50;
    }

    default public DialogDataSet getDialogDataSet() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET);
    }

    default public void setDialogDataSet(DialogDataSet dialogDataSet) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET, dialogDataSet);
    }

    default public void clearDialogDataSet() {
        this.setDialogDataSet(new DialogDataSet());
    }

    default public boolean hasDialog() {
        return this.getDialogDataSet().hasDialog();
    }

    default public boolean hasDialog(String dialogLabel) {
        return this.getDialogDataSet().hasDialog(dialogLabel);
    }

    default public boolean hasDialog(UUID dialogId) {
        return this.getDialogDataSet().hasDialog(dialogId);
    }

    default public boolean removeDialog(UUID dialogId) {
        return this.getDialogDataSet().removeDialog(dialogId);
    }

    default public boolean removeDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().removeDialogButton(dialogId, dialogButtonId);
    }

    default public void setDialog(UUID dialogId, DialogDataEntry dialogData) {
        this.getDialogDataSet().setDialog(dialogId, dialogData);
    }

    default public UUID getDialogId(String dialogLabel) {
        return this.getDialogDataSet().getDialogId(dialogLabel);
    }

    default public boolean hasDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().hasDialogButton(dialogId, dialogButtonId);
    }

    default public void openDialog(class_3222 serverPlayer, UUID dialogId) {
        DialogDataEntry dialog = this.getDialogDataSet().getDialog(dialogId);
        if (dialog != null) {
            this.getDialogDataSet().recordDialogExecution(dialog, serverPlayer);
        }
        MenuManager.getMenuHandler().openDialogMenu(serverPlayer, this, dialogId, 0);
    }

    default public void openDefaultDialog(class_3222 serverPlayer) {
        DialogDataEntry dialog = this.getDialogDataSet().getNextAvailableDialog(serverPlayer);
        if (dialog != null) {
            this.openDialog(serverPlayer, dialog.getId());
        }
    }

    default public DialogButtonEntry getDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().getDialogButton(dialogId, dialogButtonId);
    }

    default public void defineSynchedDialogData(class_2945.class_9222 builder) {
    }

    default public void defineCustomDialogData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET, new DialogDataSet());
    }

    default public void addAdditionalDialogData(class_2487 compoundTag) {
        DialogDataSet dialogDataSet;
        class_2487 dialogDataTag = new class_2487();
        if (this.isServerSideInstance() && (dialogDataSet = this.getDialogDataSet()) != null) {
            dialogDataSet.save(dialogDataTag);
        }
        compoundTag.method_10566(DATA_DIALOG_DATA_TAG, (class_2520)dialogDataTag);
    }

    default public void readAdditionalDialogData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_DIALOG_DATA_TAG)) {
            return;
        }
        class_2487 dialogDataTag = compoundTag.method_10562(DATA_DIALOG_DATA_TAG);
        if (dialogDataTag.method_10545("DialogDataSet")) {
            DialogDataSet dialogDataSet = new DialogDataSet(dialogDataTag);
            this.setDialogDataSet(dialogDataSet);
        }
    }
}

