/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.display.DisplayAttributeDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface DisplayAttributeDataCapable<E extends class_1308>
extends EasyNPC<E> {
    public static final String DATA_DISPLAY_ATTRIBUTE_TAG = "DisplayAttribute";
    public static final class_9139<class_9129, EnumMap<DisplayAttributeType, DisplayAttributeEntry>> STREAM_CODEC = new class_9139<class_9129, EnumMap<DisplayAttributeType, DisplayAttributeEntry>>(){

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> decode(class_9129 registryFriendlyByteBuf) {
            class_2487 compoundTag = registryFriendlyByteBuf.method_10798();
            EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
            for (String key : compoundTag.method_10541()) {
                DisplayAttributeType displayAttributeType = DisplayAttributeType.get(key);
                if (displayAttributeType == null) continue;
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry(compoundTag.method_10562(key)));
            }
            return displayAttributeMap;
        }

        public void encode(class_9129 registryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : displayAttributeMap.entrySet()) {
                class_2487 entryTag = new class_2487();
                entry.getValue().write(entryTag);
                compoundTag.method_10566(entry.getKey().name(), (class_2520)entryTag);
            }
            registryFriendlyByteBuf.method_10794((class_2520)compoundTag);
        }
    };

    default public DisplayAttributeDataSet getDisplayAttributeData() {
        DisplayAttributeDataSet displayAttributeDataSet = (DisplayAttributeDataSet)this.getSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET);
        if (displayAttributeDataSet == null) {
            displayAttributeDataSet = DisplayAttributeDataSet.createDefault();
            this.setDisplayAttributeData(displayAttributeDataSet);
        }
        return displayAttributeDataSet;
    }

    default public void setDisplayAttributeData(DisplayAttributeDataSet displayAttributeDataSet) {
        if (displayAttributeDataSet != null) {
            this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, displayAttributeDataSet, true);
            this.syncDisplayAttributesToEntity(displayAttributeDataSet);
        }
    }

    default public void syncDisplayAttributesToEntity(DisplayAttributeDataSet displayAttributeDataSet) {
        DisplayAttributeEntry nameVisibilityEntry;
        if (displayAttributeDataSet.hasAttribute(DisplayAttributeType.NAME_VISIBILITY) && (nameVisibilityEntry = displayAttributeDataSet.getAttribute(DisplayAttributeType.NAME_VISIBILITY)) != null) {
            try {
                NameVisibilityType nameVisibilityType = NameVisibilityType.valueOf(nameVisibilityEntry.stringValue());
                this.getEntity().method_5880(nameVisibilityType != NameVisibilityType.NEVER);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid name visibility type: {}", (Object)nameVisibilityEntry.stringValue());
            }
        }
    }

    default public void clearDisplayAttributeData() {
        this.setDisplayAttributeData(DisplayAttributeDataSet.createDefault());
    }

    default public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        return this.getDisplayAttributeData().hasAttribute(displayAttributeType);
    }

    default public boolean getDisplayBooleanAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeEntry entry = this.getDisplayAttributeData().getAttribute(displayAttributeType);
        return entry != null && entry.booleanValue();
    }

    default public int getDisplayIntAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeEntry entry = this.getDisplayAttributeData().getAttribute(displayAttributeType);
        return entry != null ? entry.intValue() : 0;
    }

    default public String getDisplayStringAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeEntry entry = this.getDisplayAttributeData().getAttribute(displayAttributeType);
        return entry != null ? entry.stringValue() : "";
    }

    default public <T extends Enum<T>> T getDisplayEnumAttribute(DisplayAttributeType displayAttributeType, Class<T> enumClass) {
        String enumValue = this.getDisplayStringAttribute(displayAttributeType);
        try {
            return Enum.valueOf(enumClass, enumValue);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to get enum value {} for class {}: {}", (Object)enumValue, enumClass, (Object)e);
            return null;
        }
    }

    default public <T> void setDisplayAttribute(DisplayAttributeType displayAttributeType, ValueType valueType, T value) {
        DisplayAttributeEntry newEntry;
        switch (valueType) {
            case BOOLEAN: {
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry((Boolean)value);
                break;
            }
            case INTEGER: {
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry((Integer)value);
                break;
            }
            case STRING: {
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry((String)value);
                break;
            }
            default: {
                log.error("Invalid display value type {} for {}", (Object)valueType, (Object)displayAttributeType);
                DisplayAttributeEntry displayAttributeEntry = newEntry = null;
            }
        }
        if (newEntry != null) {
            this.setDisplayAttributeData(this.getDisplayAttributeData().withAttribute(displayAttributeType, newEntry));
        }
    }

    default public void setDisplayAttribute(DisplayAttributeType displayAttributeType, Enum<?> enumValue) {
        this.setDisplayAttribute(displayAttributeType, ValueType.STRING, enumValue.toString());
    }

    default public void defineSynchedDisplayAttributeData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, DisplayAttributeDataSet.createDefault());
    }

    default public void readAdditionalDisplayAttributeData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_DISPLAY_ATTRIBUTE_TAG)) {
            return;
        }
        DisplayAttributeDataSet displayAttributeData = new DisplayAttributeDataSet(compoundTag.method_10554(DATA_DISPLAY_ATTRIBUTE_TAG, 10));
        this.setDisplayAttributeData(displayAttributeData);
    }

    default public void addAdditionalDisplayAttributeData(class_2487 compoundTag) {
        DisplayAttributeDataSet displayAttributeData = this.getDisplayAttributeData();
        if (displayAttributeData != null) {
            compoundTag.method_10566(DATA_DISPLAY_ATTRIBUTE_TAG, (class_2520)displayAttributeData.save());
        }
    }
}

