/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelAnimationBehavior;
import de.markusbordihn.easynpc.data.model.ModelAnimationData;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;

public interface ModelAnimationDataCapable<T extends class_1308>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_ANIMATION_DATA_TAG = "AnimationData";

    default public ModelAnimationData getModelAnimationData() {
        ModelAnimationData animationData = (ModelAnimationData)this.getSynchedEntityData(SynchedDataIndex.MODEL_ANIMATION);
        if (animationData == null) {
            animationData = new ModelAnimationData();
            this.setModelAnimationData(animationData);
        }
        return animationData;
    }

    default public void setModelAnimationData(ModelAnimationData animationData) {
        if (animationData != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_ANIMATION, animationData);
        }
    }

    default public ModelAnimationBehavior getModelAnimationBehavior() {
        return this.getModelAnimationData().behavior();
    }

    default public void setModelAnimationBehavior(ModelAnimationBehavior behavior) {
        this.setModelAnimationData(new ModelAnimationData(behavior));
    }

    default public void defineSynchedModelAnimationData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ANIMATION, new ModelAnimationData());
    }

    default public void addAdditionalModelAnimationData(class_2487 compoundTag) {
        ModelAnimationData animationData = this.getModelAnimationData();
        if (animationData != null && animationData.hasChanged()) {
            compoundTag.method_10566(EASY_NPC_DATA_ANIMATION_DATA_TAG, (class_2520)animationData.save());
        }
    }

    default public void readAdditionalModelAnimationData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_ANIMATION_DATA_TAG)) {
            return;
        }
        class_2487 animationDataTag = compoundTag.method_10562(EASY_NPC_DATA_ANIMATION_DATA_TAG);
        ModelAnimationData animationData = new ModelAnimationData(animationDataTag);
        this.setModelAnimationData(animationData);
    }
}

