/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.model.ModelType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelAnimationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelPositionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelRotationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelScaleDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelVisibilityDataCapable;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_4050;

public interface ModelDataCapable<T extends class_1308>
extends EasyNPC<T>,
ModelAnimationDataCapable<T>,
ModelPositionDataCapable<T>,
ModelRotationDataCapable<T>,
ModelScaleDataCapable<T>,
ModelVisibilityDataCapable<T> {
    public static final String EASY_NPC_DATA_MODEL_DATA_TAG = "ModelData";
    public static final String EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG = "DefaultPose";
    public static final String EASY_NPC_DATA_MODEL_POSE_TAG = "Pose";

    default public class_4050 getDefaultPose() {
        return this.getEntity().method_18376();
    }

    default public void setDefaultPose(class_4050 pose) {
        this.getEntity().method_18380(pose);
    }

    default public ModelPose getModelPose() {
        return (ModelPose)((Object)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSE));
    }

    default public void setModelPose(ModelPose modelPose) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_POSE, modelPose);
    }

    default public ModelType getModelType() {
        return ModelType.HUMANOID;
    }

    default public boolean canUseArmor() {
        return false;
    }

    default public boolean canUseMainHand() {
        return true;
    }

    default public boolean canUseOffHand() {
        return true;
    }

    default public boolean hasChangedModel() {
        return this.hasChangedModelPosition() || this.hasChangedModelRotation() || this.hasChangedModelScale() || this.hasChangedModelVisibility();
    }

    default public void defineSynchedModelData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_POSE, ModelPose.DEFAULT);
        this.defineSynchedModelAnimationData(builder);
        this.defineSynchedModelPositionData(builder);
        this.defineSynchedModelRotationData(builder);
        this.defineSynchedModelScaleData(builder);
        this.defineSynchedModelVisibilityData(builder);
    }

    default public void addAdditionalModelData(class_2487 compoundTag) {
        class_2487 modelDataTag = new class_2487();
        if (this.getModelPose() != ModelPose.DEFAULT && this.hasChangedModel()) {
            modelDataTag.method_10582(EASY_NPC_DATA_MODEL_POSE_TAG, this.getModelPose().name());
            modelDataTag.method_10582(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, class_4050.field_18076.name());
        } else {
            modelDataTag.method_10582(EASY_NPC_DATA_MODEL_POSE_TAG, ModelPose.DEFAULT.name());
            modelDataTag.method_10582(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, this.getDefaultPose() != null ? this.getDefaultPose().name() : class_4050.field_18076.name());
        }
        this.addAdditionalModelAnimationData(compoundTag);
        this.addAdditionalModelPositionData(modelDataTag);
        this.addAdditionalModelRotationData(modelDataTag);
        this.addAdditionalModelScaleData(modelDataTag);
        this.addAdditionalModelVisibilityData(modelDataTag);
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_DATA_TAG, (class_2520)modelDataTag);
    }

    default public void readAdditionalModelData(class_2487 compoundTag) {
        String defaultPose;
        String modelPose;
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_DATA_TAG)) {
            return;
        }
        class_2487 modelDataTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_DATA_TAG);
        if (modelDataTag.method_10545(EASY_NPC_DATA_MODEL_POSE_TAG) && !(modelPose = modelDataTag.method_10558(EASY_NPC_DATA_MODEL_POSE_TAG)).isEmpty()) {
            this.setModelPose(ModelPose.get(modelPose));
        }
        if (this.getModelPose() == ModelPose.DEFAULT && modelDataTag.method_10545(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG) && !(defaultPose = modelDataTag.method_10558(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG)).isEmpty()) {
            this.setDefaultPose(class_4050.valueOf((String)defaultPose));
        }
        this.readAdditionalModelAnimationData(compoundTag);
        this.readAdditionalModelPositionData(modelDataTag);
        this.readAdditionalModelRotationData(modelDataTag);
        this.readAdditionalModelScaleData(modelDataTag);
        this.readAdditionalModelVisibilityData(modelDataTag);
    }
}

