/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface ModelRotationDataCapable<T extends class_1308>
extends EasyNPC<T> {
    public static final CustomRotation DEFAULT_MODEL_PART_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_ROTATION_TAG = "Rotation";
    public static final class_9139<class_9129, Map<ModelPartType, CustomRotation>> MODEL_PART_ROTATION_STREAM_CODEC = new class_9139<class_9129, Map<ModelPartType, CustomRotation>>(){

        public Map<ModelPartType, CustomRotation> decode(class_9129 registryFriendlyByteBuf) {
            class_2487 compoundTag = registryFriendlyByteBuf.method_10798();
            EnumMap<ModelPartType, CustomRotation> modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            for (String key : compoundTag.method_10541()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, new CustomRotation(modelPartType, compoundTag));
            }
            return modelPartMap;
        }

        public void encode(class_9129 registryFriendlyByteBuf, Map<ModelPartType, CustomRotation> modelPartMap) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry<ModelPartType, CustomRotation> entry : modelPartMap.entrySet()) {
                compoundTag.method_10566(entry.getKey().getTagName(), (class_2520)entry.getValue().save());
            }
            registryFriendlyByteBuf.method_10794((class_2520)compoundTag);
        }
    };

    default public EnumMap<ModelPartType, CustomRotation> getModelPartRotation() {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = (EnumMap<ModelPartType, CustomRotation>)this.getSynchedEntityData(SynchedDataIndex.MODEL_ROTATION);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            this.setModelPartRotation(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartRotation(EnumMap<ModelPartType, CustomRotation> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_ROTATION, modelPartMap, true);
        }
    }

    default public void setModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, rotation);
            this.setModelPartRotation(new EnumMap<ModelPartType, CustomRotation>(modelPartMap));
        }
    }

    default public CustomRotation getModelPartRotation(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_ROTATION);
    }

    default public void setModelRotation(float y) {
        CustomRotation rotation = this.getModelPartRotation(ModelPartType.ROOT);
        this.setModelRotation(rotation.x(), y, rotation.z());
    }

    default public void setModelRotation(float x, float y, float z) {
        class_1309 livingEntity;
        class_1297 entity = this.getEntity();
        if (entity != null) {
            entity.method_36456(y);
            entity.method_5636(y);
            entity.method_5847(y);
            entity.field_5982 = y;
        }
        if ((livingEntity = this.getLivingEntity()) != null) {
            livingEntity.field_6220 = y;
            livingEntity.field_6259 = y;
        }
        this.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(x, y, z).withLocked(x != 0.0f || y != 0.0f || z != 0.0f));
    }

    default public boolean hasChangedModelRotation() {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        for (CustomRotation rotation : modelPartMap.values()) {
            if (!rotation.hasChanged() || rotation == modelPartMap.get((Object)ModelPartType.ROOT) && rotation.hasChangedYaw()) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelRotationData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ROTATION, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelRotationData(class_2487 compoundTag) {
        class_2487 rotationsTag = new class_2487();
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        for (Map.Entry<ModelPartType, CustomRotation> entry : modelPartMap.entrySet()) {
            rotationsTag.method_10566(entry.getKey().getTagName(), (class_2520)entry.getValue().save());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_ROTATION_TAG, (class_2520)rotationsTag);
    }

    default public void readAdditionalModelRotationData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_ROTATION_TAG)) {
            return;
        }
        class_2487 rotationsTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_ROTATION_TAG);
        EnumMap<ModelPartType, CustomRotation> modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
        for (String key : rotationsTag.method_10541()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomRotation(modelPartType, rotationsTag));
        }
        this.setModelPartRotation(modelPartMap);
    }
}

