/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface ModelScaleDataCapable<T extends class_1308>
extends EasyNPC<T> {
    public static final CustomScale DEFAULT_MODEL_PART_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final CustomScale DEFAULT_MODEL_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final String EASY_NPC_DATA_MODEL_SCALE_TAG = "Scale";
    public static final class_9139<class_9129, Map<ModelPartType, CustomScale>> MODEL_PART_SCALE_STREAM_CODEC = new class_9139<class_9129, Map<ModelPartType, CustomScale>>(){

        public Map<ModelPartType, CustomScale> decode(class_9129 registryFriendlyByteBuf) {
            class_2487 compoundTag = registryFriendlyByteBuf.method_10798();
            EnumMap<ModelPartType, CustomScale> modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            for (String key : compoundTag.method_10541()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, new CustomScale(modelPartType, compoundTag));
            }
            return modelPartMap;
        }

        public void encode(class_9129 registryFriendlyByteBuf, Map<ModelPartType, CustomScale> modelPartMap) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
                compoundTag.method_10566(entry.getKey().getTagName(), (class_2520)entry.getValue().save());
            }
            registryFriendlyByteBuf.method_10794((class_2520)compoundTag);
        }
    };

    default public EnumMap<ModelPartType, CustomScale> getModelPartScale() {
        EnumMap<ModelPartType, CustomScale> modelPartMap = (EnumMap<ModelPartType, CustomScale>)this.getSynchedEntityData(SynchedDataIndex.MODEL_SCALE);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            this.setModelPartScale(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartScale(EnumMap<ModelPartType, CustomScale> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_SCALE, modelPartMap, true);
            if (modelPartMap.containsKey((Object)ModelPartType.ROOT)) {
                this.getEntity().method_18382();
            }
        }
    }

    default public void setModelPartScale(ModelPartType modelPartType, CustomScale Scale) {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, Scale);
            this.setModelPartScale(new EnumMap<ModelPartType, CustomScale>(modelPartMap));
        }
    }

    default public CustomScale getModelPartScale(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_SCALE);
    }

    default public boolean hasChangedModelScale() {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
            if (!entry.getValue().hasChanged()) continue;
            return true;
        }
        return false;
    }

    default public CustomScale getDefaultModelScale() {
        return DEFAULT_MODEL_SCALE;
    }

    default public void defineSynchedModelScaleData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_SCALE, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelScaleData(class_2487 compoundTag) {
        class_2487 positionsTag = new class_2487();
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
            positionsTag.method_10566(entry.getKey().getTagName(), (class_2520)entry.getValue().save());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_SCALE_TAG, (class_2520)positionsTag);
    }

    default public void readAdditionalModelScaleData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_SCALE_TAG)) {
            return;
        }
        class_2487 positionTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_SCALE_TAG);
        EnumMap<ModelPartType, CustomScale> modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
        for (String key : positionTag.method_10541()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomScale(modelPartType, positionTag));
        }
        this.setModelPartScale(modelPartMap);
    }
}

