/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_6025;

public interface OwnerDataCapable<T extends class_1308>
extends EasyNPC<T>,
class_6025 {
    public static final String DATA_OWNER_TAG = "Owner";

    default public void setNPCOwnerUUID(UUID uuid) {
        this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.ofNullable(uuid));
    }

    default public boolean hasNPCOwner() {
        return this.method_6139() != null;
    }

    default public boolean isNPCOwnedBy(class_1309 livingEntity) {
        return livingEntity != null && this.hasNPCOwner() && livingEntity.method_5667().equals(this.method_6139());
    }

    default public void setNPCOwner(class_1309 owner) {
        if (owner != null) {
            this.setNPCOwnerUUID(owner.method_5667());
        } else {
            this.setNPCOwnerUUID(null);
        }
    }

    default public String getNPCOwnerName() {
        class_1309 owner = this.method_35057();
        return owner == null ? "" : owner.method_5477().getString();
    }

    default public boolean isNPCOwner(class_3222 serverPlayer) {
        return serverPlayer != null && this.isNPCOwner(serverPlayer.method_5667());
    }

    default public boolean isNPCOwner(UUID uuid) {
        return uuid != null && this.hasNPCOwner() && uuid.equals(this.method_6139());
    }

    default public UUID method_6139() {
        Optional ownerUUID = (Optional)this.getSynchedEntityData(SynchedDataIndex.OWNER_UUID);
        return ownerUUID.orElse(null);
    }

    default public class_1309 method_35057() {
        class_1937 level = this.getEntityLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.method_6139();
            return uuid == null ? null : level.method_18470(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public void defineSynchedOwnerData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.OWNER_UUID, Optional.empty());
    }

    default public void addAdditionalOwnerData(class_2487 compoundTag) {
        if (this.method_6139() != null) {
            compoundTag.method_25927(DATA_OWNER_TAG, this.method_6139());
        }
    }

    default public void readAdditionalOwnerData(class_2487 compoundTag) {
        if (compoundTag.method_25928(DATA_OWNER_TAG)) {
            UUID uuid = compoundTag.method_25926(DATA_OWNER_TAG);
            this.setNPCOwnerUUID(uuid);
        }
    }
}

