/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2945;

public interface ProfessionDataCapable<T extends class_1308>
extends EasyNPC<T> {
    public static final String DATA_PROFESSION_TAG = "Profession";

    default public Profession getDefaultProfession() {
        return Profession.NONE;
    }

    default public Profession getProfession() {
        return (Profession)((Object)this.getSynchedEntityData(SynchedDataIndex.PROFESSION));
    }

    default public void setProfession(Profession profession) {
        this.setSynchedEntityData(SynchedDataIndex.PROFESSION, profession);
    }

    default public Profession getProfession(String name) {
        return Profession.valueOf(name);
    }

    default public boolean hasProfessions() {
        return false;
    }

    default public Profession[] getProfessions() {
        return Profession.values();
    }

    default public class_2561 getProfessionName() {
        Profession profession = this.getProfession();
        return profession != null ? TextUtils.normalizeName(profession.name()) : TextComponent.getBlankText();
    }

    default public void defineSynchedProfessionData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.PROFESSION, this.getDefaultProfession());
    }

    default public void addAdditionalProfessionData(class_2487 compoundTag) {
        if (this.getProfession() != null) {
            compoundTag.method_10582(DATA_PROFESSION_TAG, this.getProfession().name());
        }
    }

    default public void readAdditionalProfessionData(class_2487 compoundTag) {
        String profession;
        if (compoundTag.method_10545(DATA_PROFESSION_TAG) && !(profession = compoundTag.method_10558(DATA_PROFESSION_TAG)).isEmpty()) {
            this.setProfession(this.getProfession(profession));
        }
    }
}

