/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.progression.ProgressionData;
import de.markusbordihn.easynpc.data.progression.ProgressionLevelMap;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.ProgressionAttributeHandler;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_3218;

public interface ProgressionDataCapable<E extends class_1308>
extends EasyNPC<E> {
    default public ProgressionData getProgressionData() {
        return (ProgressionData)this.getSynchedEntityData(SynchedDataIndex.PROGRESSION);
    }

    default public void setProgressionData(ProgressionData progressionData) {
        this.setSynchedEntityData(SynchedDataIndex.PROGRESSION, progressionData);
    }

    default public int getExperience() {
        ProgressionData data = this.getProgressionData();
        return data != null ? data.experience() : 1;
    }

    default public void setExperience(int experience) {
        ProgressionData oldData = this.getProgressionData();
        if (oldData == null) {
            return;
        }
        int clampedXP = Math.max(1, Math.min(experience, ProgressionLevelMap.getExperienceForLevel(60)));
        int newLevel = ProgressionLevelMap.getLevelForExperience(clampedXP);
        ProgressionData newData = new ProgressionData(clampedXP, newLevel, oldData.attributeScalingEnabled());
        this.setProgressionData(newData);
        if (oldData.experienceLevel() != newLevel) {
            this.onProgressLevelChange(oldData, newData);
        }
    }

    default public int getExperienceLevel() {
        ProgressionData data = this.getProgressionData();
        return data != null ? data.experienceLevel() : 1;
    }

    default public void setExperienceLevel(int level) {
        ProgressionData oldData = this.getProgressionData();
        if (oldData == null) {
            return;
        }
        int clampedLevel = Math.max(1, Math.min(level, 60));
        int newXP = ProgressionLevelMap.getExperienceForLevel(clampedLevel);
        ProgressionData newData = new ProgressionData(newXP, clampedLevel, oldData.attributeScalingEnabled());
        this.setProgressionData(newData);
        if (oldData.experienceLevel() != clampedLevel) {
            this.onProgressLevelChange(oldData, newData);
        }
    }

    default public boolean isAttributeScalingEnabled() {
        ProgressionData data = this.getProgressionData();
        return data != null && data.attributeScalingEnabled();
    }

    default public void setAttributeScalingEnabled(boolean enabled) {
        ProgressionData oldData = this.getProgressionData();
        if (oldData == null) {
            return;
        }
        ProgressionData newData = new ProgressionData(oldData.experience(), oldData.experienceLevel(), enabled);
        this.setProgressionData(newData);
        ProgressionAttributeHandler.applyLevelScaling(this);
    }

    default public void addExperience(int amount) {
        this.setExperience(this.getExperience() + amount);
    }

    default public void increaseExperience(int experience) {
        this.addExperience(experience);
    }

    default public void decreaseExperience(int experience) {
        this.addExperience(-experience);
    }

    default public void increaseExperienceLevel(int levels) {
        this.setExperienceLevel(this.getExperienceLevel() + levels);
    }

    default public void decreaseExperienceLevel(int levels) {
        this.setExperienceLevel(this.getExperienceLevel() - levels);
    }

    default public void decreaseExperienceAndExperienceLevel() {
        int currentLevel = this.getExperienceLevel();
        this.decreaseExperience(ProgressionLevelMap.getExperienceDifferenceForLevel(currentLevel));
    }

    default public boolean isMaxExperienceLevel() {
        return this.getExperienceLevel() >= this.getMaxExperienceLevel();
    }

    default public boolean isMinExperienceLevel() {
        return this.getExperienceLevel() == this.getMinExperienceLevel();
    }

    default public int getMaxExperienceLevel() {
        return 60;
    }

    default public int getMinExperienceLevel() {
        return 1;
    }

    default public int getExperienceForNextLevel() {
        return ProgressionLevelMap.getExperienceForNextLevel(this.getExperienceLevel());
    }

    default public int getExperienceForLevel() {
        return ProgressionLevelMap.getExperienceForLevel(this.getExperienceLevel());
    }

    default public int getExperienceProgressToNextLevel() {
        ProgressionData data = this.getProgressionData();
        return data != null ? ProgressionLevelMap.getExperienceProgressToNextLevel(data.experience(), data.experienceLevel()) : 0;
    }

    default public float getProgressPercentageToNextLevel() {
        ProgressionData data = this.getProgressionData();
        return data != null ? ProgressionLevelMap.getProgressPercentageToNextLevel(data.experience(), data.experienceLevel()) : 0.0f;
    }

    default public int getAttributeAdjustment(int baseValue, int maxValue) {
        int level = this.getExperienceLevel();
        if (level == 1 || maxValue == 0 || baseValue >= maxValue) {
            return 0;
        }
        double factor = (double)(maxValue - baseValue) / (double)this.getMaxExperienceLevel();
        return (int)Math.floor((double)level * factor + 0.5);
    }

    default public void onProgressLevelChange(ProgressionData oldData, ProgressionData newData) {
        int oldLevel = oldData.experienceLevel();
        int newLevel = newData.experienceLevel();
        if (newLevel > oldLevel) {
            this.onProgressLevelUp(oldData, newData);
        } else if (newLevel < oldLevel) {
            this.onProgressLevelDown(oldData, newData);
        }
        ProgressionAttributeHandler.applyLevelScaling(this);
    }

    default public void onProgressLevelUp(ProgressionData oldData, ProgressionData newData) {
        class_1937 class_19372 = this.getEntity().method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11215, this.getEntity().method_23317(), this.getEntity().method_23318() + (double)this.getEntity().method_17682() / 2.0, this.getEntity().method_23321(), 50, 0.5, 0.5, 0.5, 0.5);
        }
        log.debug("{} leveled up from {} to {}!", (Object)this.getEntity(), (Object)oldData.experienceLevel(), (Object)newData.experienceLevel());
    }

    default public void onProgressLevelDown(ProgressionData oldData, ProgressionData newData) {
        class_1937 class_19372 = this.getEntity().method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11251, this.getEntity().method_23317(), this.getEntity().method_23318() + (double)this.getEntity().method_17682() / 2.0, this.getEntity().method_23321(), 50, 0.5, 0.5, 0.5, 0.5);
        }
        log.debug("{} leveled down from {} to {}!", (Object)this.getEntity(), (Object)oldData.experienceLevel(), (Object)newData.experienceLevel());
    }

    default public void defineSynchedProgressionData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.PROGRESSION, new ProgressionData());
    }

    default public void addAdditionalProgressionData(class_2487 compoundTag) {
        ProgressionData progressionData = this.getProgressionData();
        if (progressionData != null) {
            progressionData.encode(compoundTag);
        }
    }

    default public void readAdditionalProgressionData(class_2487 compoundTag) {
        this.setProgressionData(ProgressionData.decode(compoundTag));
    }
}

