/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.status.StatusDataType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public interface StatusDataCapable<T extends class_1308>
extends EasyNPC<T> {
    public static final String DATA_STATUS_DATA_TAG = "Status";

    public EnumMap<StatusDataType, Boolean> getStatusDataFlags();

    public EnumMap<StatusDataType, Long> getStatusDataTimestamps();

    default public boolean getStatusDataFlag(StatusDataType key) {
        return this.getStatusDataFlags().getOrDefault((Object)key, false);
    }

    default public void setStatusDataFlag(StatusDataType key, boolean value) {
        this.getStatusDataFlags().put(key, value);
    }

    default public long getStatusDataTimestamp(StatusDataType key) {
        return this.getStatusDataTimestamps().getOrDefault((Object)key, 0L);
    }

    default public void setStatusDataTimestamp(StatusDataType key, long timestamp) {
        this.getStatusDataTimestamps().put(key, timestamp);
    }

    default public boolean hasUnsavedNPCData() {
        return this.getStatusDataTimestamp(StatusDataType.NPC_DATA_LAST_UPDATE) > this.getStatusDataTimestamp(StatusDataType.NPC_DATA_LAST_SAVED);
    }

    default public void markNPCDataUpdated() {
        this.setStatusDataTimestamp(StatusDataType.NPC_DATA_LAST_UPDATE, System.currentTimeMillis());
    }

    default public void markNPCDataSaved() {
        this.setStatusDataTimestamp(StatusDataType.NPC_DATA_LAST_SAVED, System.currentTimeMillis());
    }

    default public void addAdditionalStatusData(class_2487 compoundTag) {
        class_2487 statusTag = new class_2487();
        if (!this.getStatusDataFlag(StatusDataType.FINALIZED)) {
            this.setStatusDataFlag(StatusDataType.FINALIZED, true);
        }
        for (StatusDataType statusDataType : StatusDataType.values()) {
            Comparable<Boolean> value;
            if (statusDataType.isBoolean()) {
                value = this.getStatusDataFlags().get((Object)statusDataType);
                if (value == null) continue;
                statusTag.method_10556(statusDataType.getTagName(), ((Boolean)value).booleanValue());
                continue;
            }
            if (!statusDataType.isTimestamp() || (value = this.getStatusDataTimestamps().get((Object)statusDataType)) == null || (Long)value <= 0L) continue;
            statusTag.method_10544(statusDataType.getTagName(), ((Long)value).longValue());
        }
        compoundTag.method_10566(DATA_STATUS_DATA_TAG, (class_2520)statusTag);
    }

    default public void readAdditionalStatusData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_STATUS_DATA_TAG)) {
            return;
        }
        class_2487 statusTag = compoundTag.method_10562(DATA_STATUS_DATA_TAG);
        for (String key : statusTag.method_10541()) {
            StatusDataType statusDataType = StatusDataType.get(key);
            if (statusDataType == null) continue;
            if (statusDataType.isBoolean()) {
                this.setStatusDataFlag(statusDataType, statusTag.method_10577(key));
                continue;
            }
            if (!statusDataType.isTimestamp()) continue;
            this.setStatusDataTimestamp(statusDataType, statusTag.method_10537(key));
        }
    }
}

