/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.event;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_3222;
import net.minecraft.class_5454;

public final class EasyNPCEventHandler {
    public static <E extends class_1308> void handlePlayerJoinEvent(EasyNPC<E> easyNPC, class_3222 serverPlayer) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onPlayerJoinUpdateObjective(serverPlayer);
        }
    }

    public static <E extends class_1308> void handlePlayerLeaveEvent(EasyNPC<E> easyNPC, class_3222 serverPlayer) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onPlayerLeaveUpdateObjective(serverPlayer);
        }
    }

    public static <E extends class_1308> void handleLivingEntityJoinEvent(EasyNPC<E> easyNPC, class_1309 livingEntity) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onLivingEntityJoinUpdateObjective(livingEntity);
        }
    }

    public static <E extends class_1308> void handleLivingEntityLeaveEvent(EasyNPC<E> easyNPC, class_1309 livingEntity) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onLivingEntityLeaveUpdateObjective(livingEntity);
        }
    }

    public static <E extends class_1308> void handleEasyNPCJoinEvent(EasyNPC<E> easyNPC, EasyNPC<?> entity) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null && entity != null) {
            objectiveData.onEasyNPCJoinUpdateObjective(entity);
        }
    }

    public static <E extends class_1308> void handleEasyNPCLeaveEvent(EasyNPC<E> easyNPC, EasyNPC<?> entity) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null && entity != null) {
            objectiveData.onEasyNPCLeaveUpdateObjective(entity);
        }
    }

    public static <E extends class_1308> void handleDieEvent(EasyNPC<E> easyNPC, class_1282 damageSource) {
        ActionEventDataCapable actionEventData;
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopMerchantTrading();
        }
        if ((actionEventData = easyNPC.getEasyNPCActionEventData()) != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_DEATH, EasyNPCEventHandler.getServerPlayerFromDamageSource(damageSource));
        }
    }

    public static <E extends class_1308> void handleKillEvent(EasyNPC<E> easyNPC) {
        ActionEventDataCapable actionEventData;
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopMerchantTrading();
        }
        if ((actionEventData = easyNPC.getEasyNPCActionEventData()) != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_KILL);
        }
    }

    public static <E extends class_1308> void handleChangeDimensionEvent(EasyNPC<E> easyNPC, class_5454 dimensionTransition) {
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopMerchantTrading();
        }
    }

    public static <E extends class_1308> void handleHurtEvent(EasyNPC<E> easyNPC, class_1282 damageSource, float damage) {
        ActionEventDataCapable actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_HURT, EasyNPCEventHandler.getServerPlayerFromDamageSource(damageSource));
        }
    }

    private static class_3222 getServerPlayerFromDamageSource(class_1282 damageSource) {
        class_1676 projectile;
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_12972;
            return serverPlayer;
        }
        class_1297 class_12973 = damageSource.method_5526();
        if (class_12973 instanceof class_1676 && (class_12973 = (projectile = (class_1676)class_12973).method_24921()) instanceof class_3222) {
            class_3222 serverPlayerOfProjectile = (class_3222)class_12973;
            return serverPlayerOfProjectile;
        }
        return null;
    }
}

