/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import java.util.Objects;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisibilityHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final double NEAR_NAME_VISIBILITY_RANGE = 8.0;
    private static final double MID_NAME_VISIBILITY_RANGE = 16.0;

    private VisibilityHandler() {
    }

    public static boolean handleIsInvisible(EasyNPC<?> easyNPC, boolean isInvisible) {
        if (easyNPC.getLivingEntity().method_6059(class_1294.field_5912)) {
            return false;
        }
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData != null && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE)) {
            return true;
        }
        return isInvisible;
    }

    public static boolean handleIsInvisibleToPlayer(EasyNPC<?> easyNPC, class_1657 player, boolean isInvisibleToPlayers) {
        boolean visibleToTeamEnabled;
        boolean visibleToOwnerEnabled;
        if (easyNPC.getLivingEntity().method_6059(class_1294.field_5912)) {
            return false;
        }
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            return isInvisibleToPlayers;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE)) {
            return true;
        }
        OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
        boolean isOwner = ownerData != null && ownerData.hasNPCOwner() && Objects.equals(ownerData.method_6139(), player.method_5667());
        boolean bl = visibleToOwnerEnabled = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_TO_OWNER) && displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_TO_OWNER);
        if (isOwner && visibleToOwnerEnabled) {
            return false;
        }
        class_268 playerTeam = player.method_5781();
        class_268 npcTeam = easyNPC.getLivingEntity().method_5781();
        boolean bl2 = visibleToTeamEnabled = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_TO_TEAM) && displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_TO_TEAM);
        if (npcTeam != null && playerTeam != null && npcTeam.equals(playerTeam) && visibleToTeamEnabled && npcTeam.method_1199()) {
            return false;
        }
        boolean isCreativeMode = player.method_7337();
        boolean isSpectatorMode = player.method_7325();
        boolean isStandardMode = !isCreativeMode && !isSpectatorMode;
        boolean gameModeVisibilitySet = false;
        boolean visibleInCurrentGameMode = false;
        if (isCreativeMode && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE)) {
            gameModeVisibilitySet = true;
            visibleInCurrentGameMode = displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE);
        } else if (isSpectatorMode && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR)) {
            gameModeVisibilitySet = true;
            visibleInCurrentGameMode = displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR);
        } else if (isStandardMode && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD)) {
            gameModeVisibilitySet = true;
            visibleInCurrentGameMode = displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD);
        }
        if (gameModeVisibilitySet && visibleInCurrentGameMode) {
            return false;
        }
        long dayTime = player.method_37908().method_8532() % 24000L;
        boolean isDayTime = dayTime >= 1000L && dayTime <= 13000L;
        boolean isNightTime = !isDayTime;
        boolean visibleAtDaySet = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_AT_DAY);
        boolean visibleAtNightSet = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT);
        if (isDayTime && visibleAtDaySet || isNightTime && visibleAtNightSet) {
            boolean visibleAtCurrentTime;
            boolean bl3 = visibleAtCurrentTime = isDayTime ? displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_AT_DAY) : displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT);
            if (visibleAtCurrentTime) {
                return false;
            }
            if (!gameModeVisibilitySet) {
                return true;
            }
        }
        if (gameModeVisibilitySet && !visibleInCurrentGameMode) {
            return true;
        }
        return isDayTime && !visibleAtDaySet && visibleAtNightSet || isNightTime && !visibleAtNightSet && visibleAtDaySet;
    }

    public static boolean handleIsCustomNameVisible(EasyNPC<?> easyNPC, boolean isCustomNameVisible) {
        return VisibilityHandler.evaluateNameVisibility(easyNPC, null, isCustomNameVisible);
    }

    public static boolean handleIsCustomNameVisibleToPlayer(EasyNPC<?> easyNPC, class_1657 player, boolean isCustomNameVisible) {
        if (easyNPC.getEntity().method_37908().method_8608() && class_310.method_1551().field_1690.field_1842) {
            return false;
        }
        return VisibilityHandler.evaluateNameVisibility(easyNPC, player, isCustomNameVisible);
    }

    private static boolean evaluateNameVisibility(EasyNPC<?> easyNPC, class_1657 player, boolean fallbackVisibility) {
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        }
        if (!displayAttributeData.hasDisplayAttribute(DisplayAttributeType.NAME_VISIBILITY)) {
            return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        }
        String nameVisibilityString = displayAttributeData.getDisplayStringAttribute(DisplayAttributeType.NAME_VISIBILITY);
        try {
            NameVisibilityType nameVisibilityType = NameVisibilityType.valueOf(nameVisibilityString);
            return VisibilityHandler.evaluateNameVisibilityType(easyNPC, player, nameVisibilityType, fallbackVisibility);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid name visibility type: {}", easyNPC, (Object)nameVisibilityString);
            return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        }
    }

    private static boolean evaluateNameVisibilityType(EasyNPC<?> easyNPC, class_1657 player, NameVisibilityType nameVisibilityType, boolean fallbackVisibility) {
        return switch (nameVisibilityType) {
            case NameVisibilityType.NEVER -> false;
            case NameVisibilityType.ALWAYS -> true;
            case NameVisibilityType.NEAR -> VisibilityHandler.evaluateDistanceBasedVisibility(easyNPC, player, 8.0, fallbackVisibility);
            case NameVisibilityType.MID -> VisibilityHandler.evaluateDistanceBasedVisibility(easyNPC, player, 16.0, fallbackVisibility);
            case NameVisibilityType.MOUSE_OVER -> VisibilityHandler.evaluateMouseOverVisibility(easyNPC);
            default -> VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        };
    }

    private static boolean evaluateDistanceBasedVisibility(EasyNPC<?> easyNPC, class_1657 player, double range, boolean fallbackVisibility) {
        double rangeSquared;
        if (!easyNPC.getEntity().method_16914()) {
            return false;
        }
        if (player == null) {
            return fallbackVisibility;
        }
        double distanceSquared = easyNPC.getEntity().method_5858((class_1297)player);
        if (distanceSquared > (rangeSquared = range * range)) {
            return false;
        }
        class_268 npcTeam = easyNPC.getLivingEntity().method_5781();
        if (npcTeam != null) {
            class_270.class_272 teamNameTagVisibility = npcTeam.method_1201();
            return switch (teamNameTagVisibility) {
                case class_270.class_272.field_1443 -> false;
                case class_270.class_272.field_1444 -> {
                    class_268 playerTeam = player.method_5781();
                    if (playerTeam != null && npcTeam.method_1206((class_270)playerTeam) && (npcTeam.method_1199() || !easyNPC.getEntity().method_5756(player))) {
                        yield true;
                    }
                    yield false;
                }
                case class_270.class_272.field_1446 -> {
                    class_268 playerTeam2 = player.method_5781();
                    if (playerTeam2 == null || !npcTeam.method_1206((class_270)playerTeam2) && !easyNPC.getEntity().method_5756(player)) {
                        yield true;
                    }
                    yield false;
                }
                default -> !easyNPC.getEntity().method_5756(player);
            };
        }
        return !easyNPC.getEntity().method_5756(player);
    }

    private static boolean evaluateMouseOverVisibility(EasyNPC<?> easyNPC) {
        if (!easyNPC.getEntity().method_16914()) {
            return false;
        }
        if (!easyNPC.getEntity().method_37908().method_8608()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1719 == null || minecraft.field_1692 == null) {
            return false;
        }
        return minecraft.field_1692 == easyNPC.getEntity() && !easyNPC.getEntity().method_5782();
    }

    private static boolean hasCustomNameFallback(EasyNPC<?> easyNPC, boolean fallbackVisibility) {
        return easyNPC.getEntity().method_16914() && fallbackVisibility;
    }
}

