/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.CommandExecutor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandActionExecutor {
    protected static final Logger log = LogManager.getLogger(CommandActionExecutor.class);

    private CommandActionExecutor() {
    }

    public static void executeAsPlayer(ActionDataEntry actionDataEntry, class_3222 serverPlayer, class_1309 livingEntity, ActionEventDataCapable<?> actionEventData) {
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int userPermissionLevel = actionDataEntry.permissionLevel();
        if (userPermissionLevel > actionEventData.getActionPermissionLevel()) {
            log.warn("User permission level {} is lower than action permission level {} for action {}", (Object)actionEventData.getActionPermissionLevel(), (Object)userPermissionLevel, (Object)actionDataEntry);
            userPermissionLevel = actionEventData.getActionPermissionLevel();
        }
        log.debug("Try to execute action {} as user {} with user permission level {} of requested action permission level {} ...", (Object)actionDataEntry, (Object)serverPlayer, (Object)userPermissionLevel, (Object)actionDataEntry.permissionLevel());
        CommandExecutor.executePlayerCommand(actionDataEntry.getAction(livingEntity, serverPlayer), serverPlayer, userPermissionLevel, actionDataEntry.enableDebug());
    }

    public static void executeAsEntity(ActionDataEntry actionDataEntry, class_3222 serverPlayer, class_1297 entity, class_1309 livingEntity, ActionEventDataCapable<?> actionEventData) {
        if (serverPlayer == null ? !ActionValidator.validateActionDataWithoutPlayer(actionDataEntry) : !ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        if (actionEventData == null) {
            log.error("No action event data found for action {}", (Object)actionDataEntry);
            return;
        }
        int ownerPermissionLevel = actionEventData.getActionPermissionLevel();
        if (ownerPermissionLevel > 3) {
            ownerPermissionLevel = 3;
        } else if (ownerPermissionLevel <= 0) {
            ownerPermissionLevel = 1;
        }
        log.debug("Try to execute action {} as entity {} with owner permission level {} of max. {} ...", (Object)actionDataEntry, (Object)entity, (Object)ownerPermissionLevel, (Object)actionEventData.getActionPermissionLevel());
        CommandExecutor.executeEntityCommand(actionDataEntry.getAction(livingEntity, serverPlayer), entity, ownerPermissionLevel, actionDataEntry.enableDebug());
    }
}

