/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1352;
import net.minecraft.class_4135;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectiveHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ObjectiveHandler() {
    }

    public static boolean addOrUpdateCustomObjective(EasyNPC<?> easyNPC, ObjectiveDataEntry objectiveDataEntry) {
        if (easyNPC == null || objectiveDataEntry == null) {
            log.error("[{}] Error adding or updating custom objective!", easyNPC);
            return false;
        }
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null) {
            log.error("[{}] No objective data available!", easyNPC);
            return false;
        }
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            log.error("[{}] Error adding or updating custom objective!", easyNPC);
            return false;
        }
        if (log.isDebugEnabled()) {
            ObjectiveHandler.logObjectiveGoals(objectiveData.getEntityGoalSelector().method_35115());
            ObjectiveHandler.logObjectiveTargets(objectiveData.getEntityTargetSelector().method_35115());
        }
        return true;
    }

    public static boolean removeCustomObjective(EasyNPC<?> easyNPC, ObjectiveDataEntry objectiveDataEntry) {
        if (easyNPC == null || objectiveDataEntry == null) {
            log.error("[{}] Error removing custom objective!", easyNPC);
            return false;
        }
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null) {
            log.error("[{}] No objective data available!", easyNPC);
            return false;
        }
        if (!objectiveData.removeCustomObjective(objectiveDataEntry)) {
            log.error("[{}] Error removing custom objective!", easyNPC);
            return false;
        }
        if (log.isDebugEnabled()) {
            ObjectiveHandler.logObjectiveGoals(objectiveData.getEntityGoalSelector().method_35115());
            ObjectiveHandler.logObjectiveTargets(objectiveData.getEntityTargetSelector().method_35115());
        }
        return true;
    }

    public static void logObjectiveGoals(Set<class_4135> goals) {
        List<class_1352> unwrappedGoals = ObjectiveHandler.getUnwrappedGoals(goals);
        if (goals != null && !goals.isEmpty() && !unwrappedGoals.isEmpty()) {
            log.debug("Goals: {}", unwrappedGoals);
        }
    }

    public static void logObjectiveTargets(Set<class_4135> goals) {
        List<class_1352> unwrappedGoals = ObjectiveHandler.getUnwrappedGoals(goals);
        if (goals != null && !goals.isEmpty() && !unwrappedGoals.isEmpty()) {
            log.debug("Targets: {}", unwrappedGoals);
        }
    }

    public static List<class_1352> getUnwrappedGoals(Set<class_4135> goals) {
        if (goals == null || goals.isEmpty()) {
            return new ArrayList<class_1352>();
        }
        ArrayList<class_1352> unwrappedGoals = new ArrayList<class_1352>();
        for (class_4135 wrappedGoal : goals) {
            unwrappedGoals.add(wrappedGoal.method_19058());
        }
        return unwrappedGoals;
    }
}

