/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetExportFormat;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private PresetHandler() {
    }

    public static boolean importPreset(class_3218 serverLevel, PresetType presetType, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        PresetData presetData = PresetHandler.loadPresetFromSource(presetType, presetLocation, serverLevel.method_8503());
        return presetData != null && PresetHandler.importPreset(serverLevel, presetData, position, uuid, serverPlayer);
    }

    public static boolean importPreset(class_3218 serverLevel, PresetData presetData, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (presetData == null || !presetData.hasValidData()) {
            log.error("[{}] Invalid preset data for import", (Object)serverLevel);
            return false;
        }
        PresetData updatedPresetData = presetData;
        if (position != null) {
            updatedPresetData = updatedPresetData.withPosition(position);
        }
        if (uuid != null) {
            updatedPresetData = updatedPresetData.withUUID(uuid);
        }
        if (!PresetHandler.importPreset(serverLevel, updatedPresetData.data())) {
            return false;
        }
        UUID finalUuid = uuid != null ? uuid : updatedPresetData.data().method_25926("UUID");
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(finalUuid, serverLevel);
        if (easyNPC == null) {
            log.error("[{}] Error importing preset, no entity found for {}", (Object)serverLevel, (Object)finalUuid);
            return false;
        }
        PresetHandler.configureImportedEntity(easyNPC, position, serverPlayer);
        return true;
    }

    private static void configureImportedEntity(EasyNPC<?> easyNPC, class_243 position, class_3222 serverPlayer) {
        NavigationDataCapable navigationData;
        OwnerDataCapable ownerData;
        if (serverPlayer != null && (ownerData = easyNPC.getEasyNPCOwnerData()) != null) {
            ownerData.setNPCOwner((class_1309)serverPlayer);
        }
        if (position != null && (navigationData = easyNPC.getEasyNPCNavigationData()) != null && !easyNPC.getEntity().method_19538().equals((Object)position)) {
            navigationData.setHomePosition(new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350));
        }
    }

    public static boolean importPreset(class_3218 serverLevel, class_2487 compoundTag) {
        UUID existingUUID;
        if (!PresetHandler.validateImportParameters(serverLevel, compoundTag)) {
            return false;
        }
        class_1299<?> entityType = PresetHandler.validateAndGetEntityType(compoundTag, serverLevel);
        if (entityType == null) {
            return false;
        }
        UUID uUID = existingUUID = compoundTag.method_10545("UUID") ? compoundTag.method_25926("UUID") : null;
        if (existingUUID != null && PresetHandler.tryUpdateExistingEntity(existingUUID, compoundTag, serverLevel)) {
            return true;
        }
        return PresetHandler.createAndImportNewEntity(entityType, compoundTag, serverLevel);
    }

    private static boolean validateImportParameters(class_3218 serverLevel, class_2487 compoundTag) {
        if (serverLevel == null || compoundTag == null) {
            log.error("[{}] Error importing preset ", (Object)serverLevel);
            return false;
        }
        if (compoundTag.method_33133()) {
            log.error("[{}] Empty preset data for import", (Object)serverLevel);
            return false;
        }
        return true;
    }

    private static class_1299<?> validateAndGetEntityType(class_2487 compoundTag, class_3218 serverLevel) {
        if (!compoundTag.method_10545("id")) {
            log.error("[{}] Error importing preset, missing entity type", (Object)serverLevel);
            return null;
        }
        class_1299 entityType = class_1299.method_5898((String)compoundTag.method_10558("id")).orElse(null);
        if (entityType == null) {
            log.error("[{}] Error importing preset, invalid entity type", (Object)serverLevel);
        }
        return entityType;
    }

    private static boolean tryUpdateExistingEntity(UUID uuid, class_2487 compoundTag, class_3218 serverLevel) {
        EasyNPC<?> existingEasyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverLevel);
        if (existingEasyNPC == null) {
            return false;
        }
        if (compoundTag.method_10545("id") && !compoundTag.method_10558("id").isEmpty() && compoundTag.method_10558("id").equals(existingEasyNPC.getEntityTypeId()) && existingEasyNPC.getEasyNPCPresetData() != null) {
            log.debug("[{}] Update preset data for existing entity {}!", (Object)serverLevel, existingEasyNPC);
            existingEasyNPC.getEasyNPCPresetData().importPresetData(compoundTag);
            return true;
        }
        LivingEntityManager.discardEasyNPCEntityByUUID(uuid, serverLevel);
        return false;
    }

    private static boolean createAndImportNewEntity(class_1299<?> entityType, class_2487 compoundTag, class_3218 serverLevel) {
        class_1297 entity = entityType.method_5883((class_1937)serverLevel);
        if (entity == null) {
            log.error("[{}] Failed to create entity of type {}", (Object)serverLevel, entityType);
            return false;
        }
        if (!(entity instanceof EasyNPC)) {
            entity.method_31472();
            log.error("[{}] Entity type {} is not an EasyNPC", (Object)serverLevel, entityType);
            return false;
        }
        EasyNPC easyNPCEntity = (EasyNPC)entity;
        PresetDataCapable presetData = easyNPCEntity.getEasyNPCPresetData();
        if (presetData == null) {
            entity.method_31472();
            log.error("[{}] No preset data available for {}", (Object)serverLevel, (Object)easyNPCEntity);
            return false;
        }
        try {
            presetData.importPresetData(compoundTag);
            if (!serverLevel.method_8649(easyNPCEntity.getEntity())) {
                entity.method_31472();
                log.error("[{}] Error spawning entity", (Object)easyNPCEntity);
                return false;
            }
            log.debug("[{}] Imported preset data {} for {}", (Object)serverLevel, (Object)compoundTag, (Object)easyNPCEntity);
            return true;
        }
        catch (Exception e) {
            entity.method_31472();
            log.error("[{}] Error importing preset data", (Object)serverLevel, (Object)e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PresetData loadPresetFromSource(PresetType presetType, class_2960 presetLocation, MinecraftServer minecraftServer) {
        if (presetLocation == null || minecraftServer == null) {
            return null;
        }
        switch (1.$SwitchMap$de$markusbordihn$easynpc$data$preset$PresetType[presetType.ordinal()]) {
            case 1: {
                v0 = var4_3 = PresetHandler.loadFromFile(CustomPresetDataFiles.getPresetsResourceLocationPath(presetLocation), presetLocation);
                break;
            }
            case 2: {
                v0 = var4_3 = PresetHandler.loadFromFile(WorldPresetDataFiles.getPresetsResourceLocationPath(presetLocation), presetLocation);
                break;
            }
            case 3: 
            case 4: {
                try {
                    resource = minecraftServer.method_34864().method_14486(presetLocation);
                    if (resource.isEmpty()) {
                        PresetHandler.log.error("{} preset resource not found at {}", (Object)presetType, (Object)presetLocation);
                        v0 = var4_3 = null;
                        ** break;
                    }
                    inputStream = ((class_3298)resource.get()).method_14482();
                    try {
                        format = PresetExportFormat.getPresetExportFormat(presetLocation.method_12832());
                        if (format == PresetExportFormat.SNBT) {
                            content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                            var4_3 = class_2522.method_10718((String)content);
                            v0 = var4_3;
                            ** break;
                        }
                        if (format == PresetExportFormat.NBT) {
                            var4_3 = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
                            v0 = var4_3;
                            ** break;
                        }
                        PresetHandler.log.error("Unknown preset format for {}", (Object)presetLocation);
                        var4_3 = null;
                        v0 = var4_3;
                        ** break;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
lbl37:
                        // 4 sources

                    }
                }
                catch (IOException exception) {
                    PresetHandler.log.error("Error reading {} preset resource {}", (Object)presetType, (Object)presetLocation, (Object)exception);
                    v0 = var4_3 = null;
                }
                catch (CommandSyntaxException exception) {
                    PresetHandler.log.error("Error parsing SNBT {} preset resource {}", (Object)presetType, (Object)presetLocation, (Object)exception);
                    v0 = var4_3 = null;
                }
                break;
            }
            default: {
                PresetHandler.log.error("Unsupported preset type for loading: {}", (Object)presetType);
                v0 = compoundTag = (var4_3 = null);
            }
        }
        if (compoundTag == null) {
            return null;
        }
        return PresetData.fromCompoundTag(presetLocation, presetType, compoundTag);
    }

    private static class_2487 loadFromFile(Path presetFile, class_2960 presetLocation) {
        if (presetFile == null) {
            log.error("Preset file path is null for: {}", (Object)presetLocation);
            return null;
        }
        return PresetFileHandler.load(presetFile.toFile());
    }

    public static boolean importLocalPreset(class_3218 serverLevel, class_2487 compoundTag, class_2960 presetLocation, class_243 position, UUID uuid, class_3222 serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing local preset {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        if (compoundTag == null || compoundTag.method_33133()) {
            log.error("[{}] Error importing local preset {}, no preset data found!", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        PresetData presetData = PresetData.fromCompoundTag(presetLocation, PresetType.LOCAL, compoundTag);
        if (presetData == null || !presetData.hasValidData()) {
            log.error("[{}] Error converting local preset to PresetData", (Object)serverLevel);
            return false;
        }
        return PresetHandler.importPreset(serverLevel, presetData, position, uuid, serverPlayer);
    }

    public static boolean exportCustomPreset(EasyNPC<?> easyNPC, String name) {
        return PresetHandler.exportPresetByType(easyNPC, name, CustomPresetDataFiles::getPresetFile);
    }

    public static boolean exportWorldPreset(EasyNPC<?> easyNPC, String name) {
        return PresetHandler.exportPresetByType(easyNPC, name, WorldPresetDataFiles::getPresetFile);
    }

    private static boolean exportPresetByType(EasyNPC<?> easyNPC, String name, BiFunction<SkinModel, String, File> fileProvider) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("[{}] Error no skin data available!", easyNPC);
            return false;
        }
        File presetFile = fileProvider.apply(skinData.getSkinModel(), name);
        return PresetHandler.exportPreset(easyNPC, presetFile);
    }

    public static boolean exportPreset(EasyNPC<?> easyNPC, File file) {
        if (easyNPC == null || file == null) {
            log.error("[{}] Error exporting preset {} !", easyNPC, (Object)file);
            return false;
        }
        PresetDataCapable presetData = easyNPC.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("[{}] Error no preset data available!", easyNPC);
            return false;
        }
        class_2487 compoundTag = presetData.serializePresetData();
        if (compoundTag == null || compoundTag.method_33133()) {
            log.error("[{}] Error exporting custom preset {}!", easyNPC, (Object)file);
            return false;
        }
        return PresetFileHandler.save(file, compoundTag);
    }

    public static class_2487 prepareClientExportData(EasyNPC<?> easyNPC, PresetMetadata metadata) {
        if (easyNPC == null) {
            log.error("Cannot prepare client export data, easyNPC is null");
            return null;
        }
        class_2487 presetData = PresetHandler.serializeAndCopyPresetData(easyNPC);
        if (presetData == null) {
            return null;
        }
        PresetMetadata finalMetadata = PresetHandler.extractAndEnrichMetadata(presetData, metadata, easyNPC);
        presetData.method_10551("PresetMetadata");
        class_2487 wrapper = new class_2487();
        wrapper.method_10566("PresetMetadata", (class_2520)finalMetadata.toCompoundTag());
        wrapper.method_10566("data", (class_2520)presetData);
        log.debug("[{}] Prepared client export data with metadata: {}", (Object)easyNPC.getEntity().method_5477().getString(), (Object)finalMetadata.category());
        return wrapper;
    }

    private static class_2487 serializeAndCopyPresetData(EasyNPC<?> easyNPC) {
        PresetDataCapable presetDataCapable = easyNPC.getEasyNPCPresetData();
        if (presetDataCapable == null) {
            log.error("[{}] No preset data available!", easyNPC);
            return null;
        }
        class_2487 originalPresetData = presetDataCapable.serializePresetData();
        if (originalPresetData == null || originalPresetData.method_33133()) {
            log.error("[{}] Error serializing preset data!", easyNPC);
            return null;
        }
        return originalPresetData.method_10553();
    }

    private static PresetMetadata extractAndEnrichMetadata(class_2487 presetData, PresetMetadata providedMetadata, EasyNPC<?> easyNPC) {
        PresetMetadata metadata = providedMetadata;
        if (presetData.method_10545("PresetMetadata")) {
            class_2487 metadataTag = presetData.method_10562("PresetMetadata");
            PresetMetadata extractedMetadata = PresetMetadata.fromCompoundTag(metadataTag);
            metadata = providedMetadata != null ? providedMetadata : extractedMetadata;
        } else if (metadata == null) {
            metadata = PresetMetadata.createDefault();
        }
        if (metadata.entityTypeId() == null || metadata.variantType() == null) {
            String entityTypeId = easyNPC.getEntityTypeId();
            String variantType = PresetHandler.extractVariantType(easyNPC);
            metadata = metadata.withPreviewData(entityTypeId, variantType);
        }
        return metadata;
    }

    private static String extractVariantType(EasyNPC<?> easyNPC) {
        VariantDataCapable variantData;
        Enum<?> variant;
        if (easyNPC instanceof VariantDataCapable && (variant = (variantData = (VariantDataCapable)easyNPC).getSkinVariantType()) != null) {
            return variant.name();
        }
        return null;
    }

    public static PresetData loadPreset(class_2960 presetLocation, PresetType presetType, MinecraftServer server) {
        if (presetLocation == null || server == null) {
            log.error("Cannot load preset, location or server is null");
            return null;
        }
        return PresetHandler.loadPresetFromSource(presetType, presetLocation, server);
    }
}

