/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProgressionDataCapable;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProgressionAttributeHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final class_2960 HEALTH_MODIFIER_ID = class_2960.method_60655((String)"easy_npc", (String)"progression_health_bonus");
    private static final class_2960 ATTACK_DAMAGE_MODIFIER_ID = class_2960.method_60655((String)"easy_npc", (String)"progression_attack_damage_bonus");
    private static final int BASE_HEALTH = 20;
    private static final int MAX_HEALTH = 100;
    private static final int BASE_ATTACK_DAMAGE = 1;
    private static final int MAX_ATTACK_DAMAGE = 20;

    private ProgressionAttributeHandler() {
    }

    public static void applyLevelScaling(EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return;
        }
        ProgressionDataCapable progressionData = easyNPC.getEasyNPCProgressionData();
        if (progressionData == null || !progressionData.isAttributeScalingEnabled()) {
            ProgressionAttributeHandler.removeLevelScaling(easyNPC);
            return;
        }
        log.debug("Applying level {} attribute scaling for {}", (Object)progressionData.getExperienceLevel(), easyNPC);
        ProgressionAttributeHandler.applyAttributeModifier(easyNPC, progressionData, (class_6880<class_1320>)class_5134.field_23716, HEALTH_MODIFIER_ID, "Progression Health Bonus", 20, 100);
        ProgressionAttributeHandler.applyAttributeModifier(easyNPC, progressionData, (class_6880<class_1320>)class_5134.field_23721, ATTACK_DAMAGE_MODIFIER_ID, "Progression Attack Damage Bonus", 1, 20);
        float currentHealth = easyNPC.getLivingEntity().method_6032();
        float maxHealth = easyNPC.getLivingEntity().method_6063();
        if (currentHealth > maxHealth) {
            easyNPC.getLivingEntity().method_6033(maxHealth);
        }
    }

    public static void removeLevelScaling(EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return;
        }
        log.debug("Removing level-based attribute modifiers for {}", easyNPC);
        ProgressionAttributeHandler.removeAttributeModifier(easyNPC, (class_6880<class_1320>)class_5134.field_23716, HEALTH_MODIFIER_ID);
        ProgressionAttributeHandler.removeAttributeModifier(easyNPC, (class_6880<class_1320>)class_5134.field_23721, ATTACK_DAMAGE_MODIFIER_ID);
        float currentHealth = easyNPC.getLivingEntity().method_6032();
        float maxHealth = easyNPC.getLivingEntity().method_6063();
        if (currentHealth > maxHealth) {
            easyNPC.getLivingEntity().method_6033(maxHealth);
        }
    }

    private static void applyAttributeModifier(EasyNPC<?> easyNPC, ProgressionDataCapable<?> progressionData, class_6880<class_1320> attribute, class_2960 modifierId, String name, int baseValue, int maxValue) {
        class_1324 attributeInstance = easyNPC.getLivingEntity().method_5996(attribute);
        if (attributeInstance == null) {
            return;
        }
        int adjustment = progressionData.getAttributeAdjustment(baseValue, maxValue);
        if (adjustment <= 0) {
            return;
        }
        if (attributeInstance.method_6199(modifierId) != null) {
            attributeInstance.method_6200(modifierId);
        }
        attributeInstance.method_26837(new class_1322(modifierId, (double)adjustment, class_1322.class_1323.field_6328));
        log.debug("Applied {} modifier: +{} (level {})", (Object)name, (Object)adjustment, (Object)progressionData.getExperienceLevel());
    }

    private static void removeAttributeModifier(EasyNPC<?> easyNPC, class_6880<class_1320> attribute, class_2960 modifierId) {
        class_1324 attributeInstance = easyNPC.getLivingEntity().method_5996(attribute);
        if (attributeInstance != null && attributeInstance.method_6199(modifierId) != null) {
            attributeInstance.method_6200(modifierId);
        }
    }
}

