/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private RenderHandler() {
    }

    public static boolean setRenderType(EasyNPC<?> easyNPC, RenderType renderType) {
        if (easyNPC == null || renderType == null) {
            log.error("[{}] Error setting render type to {}", easyNPC, (Object)renderType);
            return false;
        }
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null) {
            log.error("[{}] No render data available for setting render type {}!", easyNPC, (Object)renderType);
            return false;
        }
        log.debug("[{}] Setting render type to {}", easyNPC, (Object)renderType);
        renderData.setRenderData(renderData.getRenderDataEntry().withRenderType(renderType));
        return true;
    }

    public static boolean setRenderEntity(EasyNPC<?> easyNPC, class_1299<? extends class_1297> entityType) {
        if (easyNPC == null || entityType == null) {
            log.error("[{}] Error setting render entity to {}", easyNPC, entityType);
            return false;
        }
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataEntry() == null) {
            log.error("[{}] No render data available for setting render entity {}!", easyNPC, entityType);
            return false;
        }
        log.debug("[{}] Setting render entity to {}", easyNPC, entityType);
        renderData.setRenderData(renderData.getRenderDataEntry().withRenderEntityType(entityType));
        return true;
    }
}

