/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientDefaultPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String INDEX_PATH = "/data/easy_npc/default_preset/default_preset.index";
    private static List<class_2960> cachedPresetLocations = null;

    private ClientDefaultPresetDataFiles() {
    }

    public static Stream<class_2960> getDefaultPresetResourceLocations() {
        if (cachedPresetLocations != null) {
            return cachedPresetLocations.stream();
        }
        InputStream indexStream = ClientDefaultPresetDataFiles.class.getResourceAsStream(INDEX_PATH);
        if (indexStream == null) {
            log.error("DEFAULT preset index file not found: {}", (Object)INDEX_PATH);
            return Stream.empty();
        }
        ArrayList<class_2960> presetLocations = new ArrayList<class_2960>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(indexStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String fullPath = "default_preset/" + line;
                class_2960 resourceLocation = class_2960.method_60655((String)"easy_npc", (String)fullPath);
                if (ClientDefaultPresetDataFiles.class.getResourceAsStream("/data/easy_npc/" + fullPath) != null) {
                    presetLocations.add(resourceLocation);
                    continue;
                }
                log.warn("DEFAULT preset listed in index but not found: {}", (Object)resourceLocation);
            }
            cachedPresetLocations = presetLocations;
            log.info("Loaded {} DEFAULT presets", (Object)presetLocations.size());
        }
        catch (Exception e) {
            log.error("Failed to load DEFAULT presets: {}", (Object)e.getMessage(), (Object)e);
        }
        return presetLocations.stream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PresetData loadDefaultPresetData(class_2960 resourceLocation) {
        try (InputStream inputStream = ClientDefaultPresetDataFiles.class.getResourceAsStream("/data/" + resourceLocation.method_12836() + "/" + resourceLocation.method_12832());){
            if (inputStream == null) {
                log.error("DEFAULT preset not found: {}", (Object)resourceLocation);
                PresetData presetData = null;
                return presetData;
            }
            class_2487 compoundTag = PresetFileHandler.loadFromInputStream(inputStream, resourceLocation);
            if (compoundTag == null || compoundTag.method_33133()) {
                log.error("Failed to load data for: {}", (Object)resourceLocation);
                PresetData presetData = null;
                return presetData;
            }
            PresetData presetData = PresetData.fromCompoundTag(resourceLocation, PresetType.DEFAULT, compoundTag);
            if (presetData == null || !presetData.hasValidData()) {
                log.error("Invalid PresetData for: {}", (Object)resourceLocation);
                PresetData presetData2 = null;
                return presetData2;
            }
            PresetData presetData3 = presetData;
            return presetData3;
        }
        catch (Exception e) {
            log.error("Failed to load DEFAULT preset {}: {}", (Object)resourceLocation, (Object)e.getMessage());
            return null;
        }
    }

    public static void clearCache() {
        cachedPresetLocations = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PresetMetadata getPresetMetadata(class_2960 resourceLocation) {
        try (InputStream inputStream = ClientDefaultPresetDataFiles.class.getResourceAsStream("/data/" + resourceLocation.method_12836() + "/" + resourceLocation.method_12832());){
            if (inputStream == null) {
                log.warn("DEFAULT preset file not found for resource location: {}", (Object)resourceLocation);
                PresetMetadata presetMetadata2 = PresetMetadata.createDefault();
                return presetMetadata2;
            }
            class_2487 compoundTag = PresetFileHandler.loadFromInputStream(inputStream, resourceLocation);
            PresetMetadata presetMetadata = PresetFileHandler.extractMetadata(compoundTag);
            return presetMetadata;
        }
        catch (Exception e) {
            log.warn("Failed to load metadata for DEFAULT preset {}: {}", (Object)resourceLocation, (Object)e.getMessage());
            return PresetMetadata.createDefault();
        }
    }

    public static String getPresetDisplayName(class_2960 resourceLocation, PresetMetadata metadata) {
        return PresetFileHandler.getDisplayName(resourceLocation, metadata);
    }
}

