/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.client.pose.PoseManager;
import de.markusbordihn.easynpc.data.animation.AnimationData;
import de.markusbordihn.easynpc.data.animation.AnimationDataReader;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPoseDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "pose";
    protected static final String TEMPLATE_PREFIX = "_poses.json";

    private CustomPoseDataFiles() {
    }

    public static void registerCustomPoseData(MinecraftServer minecraftServer) {
        log.info("{} custom pose data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Path poseDataFolder = CustomPoseDataFiles.getCustomPoseDataFolder();
        if (poseDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            Path poseModelFolder = CustomPoseDataFiles.getCustomPoseDataFolder(skinModel);
            if (poseModelFolder == null) continue;
            String skinModelName = skinModel.getName();
            Map resourceLocations = minecraftServer.method_34864().method_14488("poses/" + skinModelName, fileName -> fileName.method_12836().equals("easy_npc") && fileName.toString().endsWith(TEMPLATE_PREFIX));
            for (class_2960 resourceLocation : resourceLocations.keySet()) {
                File skinModelPoseFile;
                if (!DataFileHandler.copyResourceFile(minecraftServer, resourceLocation, skinModelPoseFile = poseModelFolder.resolve(DataFileHandler.getFileNameFromResourceLocation(resourceLocation)).toFile()) || !skinModelPoseFile.exists() || skinModelPoseFile.length() <= 0L) continue;
                log.info("Copied skin model pose file {} to {}", (Object)resourceLocation, (Object)skinModelPoseFile);
            }
        }
        CustomPoseDataFiles.registerCustomPoseFiles();
    }

    public static void registerCustomPoseFiles() {
        Path poseDataFolder = CustomPoseDataFiles.getCustomPoseDataFolder();
        if (poseDataFolder == null) {
            return;
        }
        log.info("{} custom poses from {} ...", (Object)"\ud83d\udde3 Register Easy NPC: Core", (Object)poseDataFolder);
        for (SkinModel skinModel : SkinModel.values()) {
            Path poseModelFolder = CustomPoseDataFiles.getCustomPoseDataFolder(skinModel);
            if (poseModelFolder == null || !poseModelFolder.toFile().exists() || !poseModelFolder.toFile().isDirectory()) continue;
            try (Stream<Path> posePaths = Files.walk(poseModelFolder, new FileVisitOption[0]);){
                posePaths.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(TEMPLATE_PREFIX)).forEach(path -> {
                    log.info("Found custom pose file {} ...", path);
                    try {
                        AnimationData animationData = AnimationDataReader.parseAnimationFile(path);
                        PoseManager.registerPoseData(skinModel, animationData);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException e) {
                log.error("Error reading custom pose files from {}:", (Object)poseModelFolder, (Object)e);
            }
        }
    }

    public static Path getCustomPoseDataFolder() {
        return DataFileHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getCustomPoseDataFolder(SkinModel skinModel) {
        Path poseDataFolder = CustomPoseDataFiles.getCustomPoseDataFolder();
        if (poseDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path poseDataFolderPath = poseDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(poseDataFolderPath, new LinkOption[0]) && Files.isDirectory(poseDataFolderPath, new LinkOption[0])) {
                return poseDataFolderPath;
            }
            log.info("Created new pose data folder {} at {}!", (Object)skinModelName, (Object)poseDataFolderPath);
            return Files.createDirectories(poseDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Error creating pose data folder {} at {}:", (Object)skinModelName, (Object)poseDataFolderPath, (Object)e);
            return null;
        }
    }
}

