/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "preset";
    private static final ConcurrentHashMap<class_2960, Path> presetResourceLocationMap = new ConcurrentHashMap();

    private CustomPresetDataFiles() {
    }

    public static void registerCustomPresetData() {
        log.info("{} custom preset data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Path presetDataFolder = CustomPresetDataFiles.getPresetDataFolder();
        if (presetDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            CustomPresetDataFiles.getPresetDataFolder(skinModel);
        }
        CustomPresetDataFiles.refreshPresetResourceLocations();
    }

    public static Path getPresetDataFolder() {
        return DataFileHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path skinDataFolder = CustomPresetDataFiles.getPresetDataFolder();
        if (skinDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path presetDataFolderPath = skinDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(presetDataFolderPath, new LinkOption[0]) && Files.isDirectory(presetDataFolderPath, new LinkOption[0])) {
                return presetDataFolderPath;
            }
            log.info("Creating preset data folder {} at {} ...", (Object)skinModelName, (Object)presetDataFolderPath);
            return Files.createDirectories(presetDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException exception) {
            log.error("Could not create preset data folder {}:", (Object)skinDataFolder, (Object)exception);
            return null;
        }
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = CustomPresetDataFiles.getPresetDataFolder(skinModel);
        if (presetModelFolder == null || fileName == null || fileName.isEmpty()) {
            return null;
        }
        String sanitizedFileName = DataFileHandler.getPresetFileName(fileName);
        if (sanitizedFileName == null) {
            return null;
        }
        return presetModelFolder.resolve(sanitizedFileName).toFile();
    }

    public static File getPresetFile(SkinModel skinModel, UUID uuid) {
        return CustomPresetDataFiles.getPresetFile(skinModel, uuid.toString());
    }

    public static Stream<class_2960> getPresetResourceLocations(SkinModel skinModel) {
        String searchName = "/" + skinModel.getName() + "/";
        return CustomPresetDataFiles.getPresetResourceLocations().filter(resourceLocation -> resourceLocation.toString().contains(searchName) && DataFileHandler.isPresetFile(resourceLocation));
    }

    public static Stream<class_2960> getPresetResourceLocations() {
        return presetResourceLocationMap.keySet().stream();
    }

    public static Set<class_2960> getPresetResourceLocationSet() {
        return presetResourceLocationMap.keySet();
    }

    public static void refreshPresetResourceLocations() {
        Path presetDataFolder = CustomPresetDataFiles.getPresetDataFolder();
        if (presetDataFolder == null) {
            return;
        }
        presetResourceLocationMap.clear();
        try (Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);){
            filesStream.filter(DataFileHandler::isPresetFile).forEach(path -> {
                class_2960 resourceLocation = class_2960.method_60655((String)"easy_npc", (String)("preset/" + presetDataFolder.relativize((Path)path).toString().replace("\\", "/").toLowerCase(Locale.ROOT)));
                presetResourceLocationMap.put(resourceLocation, (Path)path);
            });
        }
        catch (IOException exception) {
            log.error("Could not read custom preset data folder {}:", (Object)presetDataFolder, (Object)exception);
        }
    }

    public static Path getPresetsResourceLocationPath(class_2960 resourceLocation) {
        Path path = presetResourceLocationMap.get(resourceLocation);
        if (path == null) {
            log.debug("Preset {} not in cache, triggering refresh", (Object)resourceLocation);
            CustomPresetDataFiles.refreshPresetResourceLocations();
            path = presetResourceLocationMap.get(resourceLocation);
            if (path == null) {
                log.debug("Preset {} not found after refresh", (Object)resourceLocation);
            }
        }
        return path;
    }

    public static PresetMetadata getPresetMetadata(class_2960 resourceLocation) {
        Path presetPath = CustomPresetDataFiles.getPresetsResourceLocationPath(resourceLocation);
        if (presetPath == null) {
            log.warn("Preset file not found for resource location: {}", (Object)resourceLocation);
            return PresetMetadata.createDefault();
        }
        class_2487 compoundTag = PresetFileHandler.load(presetPath.toFile());
        return PresetFileHandler.extractMetadata(compoundTag);
    }

    public static String getPresetDisplayName(class_2960 resourceLocation, PresetMetadata metadata) {
        return PresetFileHandler.getDisplayName(resourceLocation, metadata);
    }
}

