/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import java.io.InputStream;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private DataPresetDataFiles() {
    }

    public static Stream<class_2960> getPresetResourceLocations(MinecraftServer minecraftServer) {
        try {
            return minecraftServer.method_34864().method_14488("preset", resourceLocation -> resourceLocation.method_12836().equals("easy_npc") && DataFileHandler.isPresetFile(resourceLocation)).keySet().stream();
        }
        catch (Exception e) {
            log.error("Could not get default preset resource locations:", (Throwable)e);
            return Stream.empty();
        }
    }

    public static PresetMetadata getPresetMetadata(MinecraftServer minecraftServer, class_2960 resourceLocation) {
        PresetMetadata presetMetadata;
        block9: {
            class_3298 resource = minecraftServer.method_34864().method_14486(resourceLocation).orElse(null);
            if (resource == null) {
                log.warn("DATA preset resource not found: {}", (Object)resourceLocation);
                return PresetMetadata.createDefault();
            }
            InputStream inputStream = resource.method_14482();
            try {
                presetMetadata = PresetFileHandler.extractMetadata(inputStream, resourceLocation);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Failed to load metadata for DATA preset {}: {}", (Object)resourceLocation, (Object)e.getMessage());
                    return PresetMetadata.createDefault();
                }
            }
            inputStream.close();
        }
        return presetMetadata;
    }

    public static String getPresetDisplayName(class_2960 resourceLocation, PresetMetadata metadata) {
        return PresetFileHandler.getDisplayName(resourceLocation, metadata);
    }
}

