/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.io.DataFileHandler;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private DefaultPresetDataFiles() {
    }

    public static Stream<class_2960> getPresetResourceLocations(MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            log.warn("Cannot get default preset resource locations: server is null");
            return Stream.empty();
        }
        return DefaultPresetDataFiles.getPresetResourceLocations(minecraftServer.method_34864());
    }

    private static Stream<class_2960> getPresetResourceLocations(class_3300 resourceManager) {
        try {
            return resourceManager.method_14488("default_preset", resourceLocation -> {
                boolean isOurNamespace = resourceLocation.method_12836().equals("easy_npc");
                boolean isPresetFile = DataFileHandler.isPresetFile(resourceLocation);
                if (isOurNamespace && isPresetFile) {
                    log.debug("Found DEFAULT preset from DataPack: {}", resourceLocation);
                }
                return isOurNamespace && isPresetFile;
            }).keySet().stream();
        }
        catch (Exception e) {
            log.error("Could not get default preset resource locations from DataPack:", (Throwable)e);
            return Stream.empty();
        }
    }
}

