/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private LocalPresetDataFiles() {
    }

    public static void registerLocalPresetData() {
        log.info("{} local preset data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPresetDataFiles.registerCustomPresetData();
    }

    public static Stream<class_2960> getPresetResourceLocations(SkinModel skinModel) {
        return CustomPresetDataFiles.getPresetResourceLocations(skinModel);
    }

    public static Stream<class_2960> getPresetResourceLocations() {
        return CustomPresetDataFiles.getPresetResourceLocations();
    }

    public static Set<class_2960> getPresetResourceLocationSet() {
        return CustomPresetDataFiles.getPresetResourceLocationSet();
    }

    public static Path getPresetsResourceLocationPath(class_2960 resourceLocation) {
        return CustomPresetDataFiles.getPresetsResourceLocationPath(resourceLocation);
    }

    public static PresetMetadata getPresetMetadata(class_2960 resourceLocation) {
        return CustomPresetDataFiles.getPresetMetadata(resourceLocation);
    }

    public static String getPresetDisplayName(class_2960 resourceLocation, PresetMetadata metadata) {
        return CustomPresetDataFiles.getPresetDisplayName(resourceLocation, metadata);
    }

    public static PresetData loadPresetData(class_2960 resourceLocation) {
        try {
            Path presetPath = LocalPresetDataFiles.getPresetsResourceLocationPath(resourceLocation);
            if (presetPath == null) {
                log.warn("Local preset file not found for: {}", (Object)resourceLocation);
                return null;
            }
            class_2487 compoundTag = PresetFileHandler.load(presetPath.toFile());
            if (compoundTag == null || compoundTag.method_33133()) {
                log.warn("Failed to load preset data from file: {}", (Object)presetPath);
                return null;
            }
            return PresetData.fromCompoundTag(resourceLocation, PresetType.LOCAL, compoundTag);
        }
        catch (Exception e) {
            log.error("Failed to load local preset data for {}: {}", (Object)resourceLocation, (Object)e.getMessage());
            return null;
        }
    }
}

