/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.data.preset.PresetExportFormat;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.utils.SnbtFormatter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetFileHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private PresetFileHandler() {
    }

    public static class_2487 load(File file) {
        if (file == null || !file.exists()) {
            log.error("Error loading preset file, file does not exist: {}", (Object)file);
            return null;
        }
        String fileName = file.getName();
        PresetExportFormat format = PresetExportFormat.getPresetExportFormat(fileName);
        return switch (format) {
            default -> throw new MatchException(null, null);
            case PresetExportFormat.NBT -> PresetFileHandler.loadNbt(file);
            case PresetExportFormat.SNBT -> PresetFileHandler.loadSnbt(file);
            case PresetExportFormat.JSON -> {
                log.warn("JSON preset format is not supported yet for file: {}!", (Object)file);
                yield PresetFileHandler.loadSnbt(file);
            }
            case PresetExportFormat.UNKNOWN -> {
                log.error("Unknown preset file format for file: {}!", (Object)file);
                yield new class_2487();
            }
        };
    }

    public static class_2487 loadNbt(File file) {
        if (file == null || !file.exists()) {
            log.error("Error loading NBT preset file, file does not exist: {}", (Object)file);
            return null;
        }
        try {
            return class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53898());
        }
        catch (IOException exception) {
            log.error("Failed to read NBT preset file {}:", (Object)file, (Object)exception);
            return null;
        }
    }

    public static class_2487 loadSnbt(File file) {
        if (file == null || !file.exists()) {
            log.error("Error loading SNBT preset file, file does not exist: {}", (Object)file);
            return null;
        }
        try {
            String content = Files.readString(file.toPath(), StandardCharsets.UTF_8);
            return class_2522.method_10718((String)content);
        }
        catch (IOException exception) {
            log.error("Failed to read SNBT preset file {}:", (Object)file, (Object)exception);
            return null;
        }
        catch (CommandSyntaxException exception) {
            log.error("Failed to parse SNBT preset file {}:", (Object)file, (Object)exception);
            return null;
        }
    }

    public static class_2487 loadFromInputStream(InputStream inputStream, class_2960 resourceLocation) {
        if (inputStream == null) {
            log.error("Error loading preset, input stream is null for: {}", (Object)resourceLocation);
            return null;
        }
        PresetExportFormat format = PresetExportFormat.getPresetExportFormat(resourceLocation.method_12832());
        try {
            if (format == PresetExportFormat.SNBT) {
                String content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                return class_2522.method_10718((String)content);
            }
            if (format == PresetExportFormat.NBT) {
                return class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
            }
            log.error("Unknown preset format for: {}", (Object)resourceLocation);
            return null;
        }
        catch (IOException exception) {
            log.error("Failed to read preset file {}:", (Object)resourceLocation, (Object)exception);
            return null;
        }
        catch (CommandSyntaxException exception) {
            log.error("Failed to parse SNBT preset file {}:", (Object)resourceLocation, (Object)exception);
            return null;
        }
    }

    public static boolean save(File file, class_2487 compoundTag) {
        if (file == null || compoundTag == null || compoundTag.method_33133()) {
            log.error("Error saving preset file {} with {} !", (Object)file, (Object)compoundTag);
            return false;
        }
        String fileName = file.getName();
        PresetExportFormat format = PresetExportFormat.getPresetExportFormat(fileName);
        if (format == PresetExportFormat.UNKNOWN) {
            log.warn("No preset extension found for file: {}, using default NBT format", (Object)file);
            return PresetFileHandler.saveNbt(file, compoundTag);
        }
        if (format == PresetExportFormat.SNBT) {
            return PresetFileHandler.saveSnbt(file, compoundTag);
        }
        return PresetFileHandler.saveNbt(file, compoundTag);
    }

    public static boolean saveNbt(File file, class_2487 compoundTag) {
        if (file == null || compoundTag == null || compoundTag.method_33133()) {
            log.error("Error exporting NBT preset file {} with {} !", (Object)file, (Object)compoundTag);
            return false;
        }
        try {
            class_2507.method_30614((class_2487)compoundTag, (Path)file.toPath());
            return true;
        }
        catch (IOException exception) {
            log.error("Failed to export NBT preset file {} with {}:", (Object)file, (Object)compoundTag, (Object)exception);
            return false;
        }
    }

    public static boolean saveSnbt(File file, class_2487 compoundTag) {
        boolean bl;
        if (file == null || compoundTag == null || compoundTag.method_33133()) {
            log.error("Error exporting SNBT preset file {} with {} !", (Object)file, (Object)compoundTag);
            return false;
        }
        FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);
        try {
            writer.write(SnbtFormatter.format(compoundTag.toString()));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                log.error("Failed to export SNBT preset file {} with {}:", (Object)file, (Object)compoundTag, (Object)exception);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static PresetMetadata extractMetadata(class_2487 compoundTag) {
        if (compoundTag == null || compoundTag.method_33133()) {
            return PresetMetadata.createDefault();
        }
        if (compoundTag.method_10545("PresetMetadata")) {
            return PresetMetadata.fromCompoundTag(compoundTag.method_10562("PresetMetadata"));
        }
        return PresetMetadata.createDefault();
    }

    public static PresetMetadata extractMetadata(InputStream inputStream, class_2960 resourceLocation) {
        class_2487 compoundTag = PresetFileHandler.loadFromInputStream(inputStream, resourceLocation);
        return PresetFileHandler.extractMetadata(compoundTag);
    }

    public static String getDisplayName(class_2960 resourceLocation, PresetMetadata metadata) {
        if (metadata == null || resourceLocation == null) {
            return "Unnamed Preset";
        }
        if ("Unnamed Preset".equals(metadata.name())) {
            String cleanFilename = PresetExportFormat.extractCleanFilename(resourceLocation.toString());
            return cleanFilename.isEmpty() ? metadata.name() : cleanFilename;
        }
        return metadata.name();
    }
}

