/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "preset";
    private static final ConcurrentHashMap<class_2960, Path> presetResourceLocationMap = new ConcurrentHashMap();

    private WorldPresetDataFiles() {
    }

    public static void registerWorldPresetData() {
        log.info("{} world preset data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        WorldPresetDataFiles.refreshPresetResourceLocations();
    }

    public static Path getPresetDataFolder() {
        File worldDataFolder = new File(Constants.WORLD_DIR.toFile(), "easy_npc");
        Path path = worldDataFolder.toPath().resolve(DATA_FOLDER_NAME);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Could not create preset data folder {}:", (Object)path, (Object)e);
        }
        return path;
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path presetDataFolder = WorldPresetDataFiles.getPresetDataFolder();
        String skinModelName = skinModel.name();
        if (!skinModelName.isEmpty()) {
            Path path = presetDataFolder.resolve(skinModelName.toLowerCase(Locale.ROOT));
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Could not create preset model folder {}:", (Object)path, (Object)e);
            }
            return path;
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = WorldPresetDataFiles.getPresetDataFolder(skinModel);
        if (presetModelFolder == null || fileName == null || fileName.isEmpty()) {
            return null;
        }
        String sanitizedFileName = DataFileHandler.getPresetFileName(fileName);
        if (sanitizedFileName == null) {
            return null;
        }
        return presetModelFolder.resolve(sanitizedFileName).toFile();
    }

    public static Stream<class_2960> getPresetResourceLocations() {
        return presetResourceLocationMap.keySet().stream();
    }

    public static Set<class_2960> getPresetResourceLocationSet() {
        return presetResourceLocationMap.keySet();
    }

    public static void refreshPresetResourceLocations() {
        Path presetDataFolder = WorldPresetDataFiles.getPresetDataFolder();
        presetResourceLocationMap.clear();
        try (Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);){
            filesStream.filter(DataFileHandler::isPresetFile).forEach(path -> {
                class_2960 resourceLocation = class_2960.method_60655((String)"easy_npc", (String)("preset/" + presetDataFolder.relativize((Path)path).toString().replace("\\", "/").toLowerCase(Locale.ROOT)));
                presetResourceLocationMap.put(resourceLocation, (Path)path);
            });
        }
        catch (IOException exception) {
            log.error("Could not read world preset data folder {}:", (Object)presetDataFolder, (Object)exception);
        }
    }

    public static Path getPresetsResourceLocationPath(class_2960 resourceLocation) {
        Path path = presetResourceLocationMap.get(resourceLocation);
        if (path == null) {
            log.debug("World preset {} not in cache, triggering refresh", (Object)resourceLocation);
            WorldPresetDataFiles.refreshPresetResourceLocations();
            path = presetResourceLocationMap.get(resourceLocation);
            if (path == null) {
                log.debug("World preset {} not found after refresh", (Object)resourceLocation);
            }
        }
        return path;
    }

    public static PresetMetadata getPresetMetadata(class_2960 resourceLocation) {
        Path presetPath = WorldPresetDataFiles.getPresetsResourceLocationPath(resourceLocation);
        if (presetPath == null) {
            log.warn("World preset file not found for resource location: {}", (Object)resourceLocation);
            return PresetMetadata.createDefault();
        }
        class_2487 compoundTag = PresetFileHandler.load(presetPath.toFile());
        return PresetFileHandler.extractMetadata(compoundTag);
    }
}

