/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.access.SpawnerAccessHelper;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetDataUtils;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetItem
extends class_1792 {
    public static final String NAME = "easy_npc_preset";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String TEXT_TAG = "text";

    public EasyNPCPresetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static UUID getPresetUUID(class_1799 itemStack) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || presetData.data() == null) {
            return null;
        }
        class_2487 compoundTag = presetData.data();
        if (compoundTag.method_10545("PresetUUID")) {
            return compoundTag.method_25926("PresetUUID");
        }
        return null;
    }

    public static String getCustomName(class_1799 itemStack) {
        class_2487 customNameTag;
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || presetData.data() == null) {
            return null;
        }
        class_2487 compoundTag = presetData.data();
        if (compoundTag.method_10545(CUSTOM_NAME_TAG) && (customNameTag = compoundTag.method_10562(CUSTOM_NAME_TAG)).method_10545(TEXT_TAG)) {
            return customNameTag.method_10558(TEXT_TAG);
        }
        return null;
    }

    public class_1269 method_7884(class_1838 useOnContext) {
        class_1937 level = useOnContext.method_8045();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 itemStack = useOnContext.method_8041();
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || !presetData.hasEntityType() || !presetData.hasData()) {
            log.warn("No valid preset found in {}!", (Object)itemStack);
            return class_1269.field_5814;
        }
        class_2338 blockPos = useOnContext.method_8037();
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof class_2636) {
            class_2636 spawnerBlockEntity = (class_2636)blockEntity;
            class_1917 baseSpawner = spawnerBlockEntity.method_11390();
            if (baseSpawner instanceof SpawnerAccessHelper) {
                SpawnerAccessHelper spawnerAccess = (SpawnerAccessHelper)baseSpawner;
                class_1952 spawnData = PresetDataUtils.toSpawnData(presetData);
                log.debug("Set spawn data {} for spawner {} at {}", (Object)spawnData, (Object)spawnerBlockEntity, (Object)blockPos);
                spawnerAccess.initializeSpawnerData(SpawnerType.SINGLE_SPAWNER, spawnData);
                spawnerBlockEntity.method_5431();
                itemStack.method_7934(1);
                return class_1269.field_21466;
            }
            log.error("BaseSpawner does not implement SpawnerAccessHelper - mixin not applied?");
            return class_1269.field_5814;
        }
        if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity easyNPCSpawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            BaseEasyNPCSpawner baseEasyNPCSpawner = easyNPCSpawnerBlockEntity.getSpawner();
            class_1952 spawnData = PresetDataUtils.toSpawnData(presetData);
            log.debug("Set spawn data {} for base NPC spawner {} at {}", (Object)spawnData, (Object)easyNPCSpawnerBlockEntity, (Object)blockPos);
            baseEasyNPCSpawner.updateSpawnData(level, blockPos, spawnData);
            easyNPCSpawnerBlockEntity.method_5431();
            level.method_8413(blockPos, level.method_8320(blockPos), level.method_8320(blockPos), 3);
            itemStack.method_7934(1);
            return class_1269.field_21466;
        }
        Iterable possibleSpawnPositions = class_2338.method_30512((class_2338)useOnContext.method_8037(), (int)4, (class_2350)class_2350.field_11043, (class_2350)class_2350.field_11034);
        for (class_2338.class_2339 possibleSpawnPosition : possibleSpawnPositions) {
            class_238 aabb = new class_238((class_2338)possibleSpawnPosition).method_1014(0.1);
            class_2338 targetBlockPos = new class_2338(possibleSpawnPosition.method_10263(), possibleSpawnPosition.method_10264() + 1, possibleSpawnPosition.method_10260());
            if (!level.method_8320(targetBlockPos.method_10084()).method_26215() || !level.method_18467(class_1297.class, aabb).isEmpty() || !PresetDataUtils.spawnEntity(presetData, level, blockPos.method_10084())) continue;
            return class_1269.field_5812;
        }
        log.error("Found no valid spawn placement for preset data: {}", (Object)presetData);
        return class_1269.field_5811;
    }

    public boolean method_7885(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        return false;
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 flag) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null) {
            return;
        }
        UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
        if (presetUUID != null) {
            tooltip.add((class_2561)TextComponent.getText(presetUUID.toString()).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset").method_27692(class_124.field_1060));
        class_1299<?> entityType = presetData.entityType();
        if (entityType != null) {
            String customName = EasyNPCPresetItem.getCustomName(itemStack);
            if (customName != null) {
                tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.custom_name", customName).method_27692(class_124.field_1080));
            }
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.entity_type", entityType.method_5897()).method_27692(class_124.field_1080));
        }
    }
}

