/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.level;

import de.markusbordihn.easynpc.access.SpawnerAccessHelper;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetDataUtils;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawner
extends class_1917 {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String SPAWN_DATA_TAG = "SpawnData";
    private static final String ENTITY_UUID_TAG = "UUID";
    private static final String STORED_PRESET_DATA_TAG = "StoredPresetData";
    private final SpawnerType spawnerType;
    private boolean isEasyNPC = false;
    private UUID easyNPCPresetUUID;
    private UUID easyNPCUUID;
    private PresetData storedPresetData;

    public BaseEasyNPCSpawner(SpawnerType spawnerType) {
        this.spawnerType = spawnerType;
        ((SpawnerAccessHelper)((Object)this)).initializeSpawnerData(spawnerType, null);
    }

    public void updateSpawnData(class_1937 level, class_2338 blockPos, class_1952 spawnData) {
        this.method_8277(level, blockPos, spawnData);
    }

    protected void method_8277(class_1937 level, class_2338 blockPos, class_1952 spawnData) {
        class_2487 originalEntityData = spawnData.method_38093();
        PresetData presetData = PresetDataUtils.fromSpawnData(spawnData);
        if (presetData != null && presetData.hasValidData()) {
            this.storedPresetData = presetData;
            this.easyNPCPresetUUID = presetData.getPresetUUID();
            this.easyNPCUUID = presetData.getEntityUUID();
            log.debug("[Spawner] Setting spawn data at {} for type {} (PresetUUID: {}, EntityUUID: {})", (Object)blockPos, (Object)this.spawnerType, (Object)this.easyNPCPresetUUID, (Object)this.easyNPCUUID);
        }
        class_2487 entityData = originalEntityData.method_10553();
        if (this.easyNPCPresetUUID != null) {
            entityData.method_25927("PresetUUID", this.easyNPCPresetUUID);
        }
        if (this.easyNPCUUID != null && this.spawnerType != SpawnerType.GROUP_SPAWNER) {
            entityData.method_25927(ENTITY_UUID_TAG, this.easyNPCUUID);
        }
        this.updateEasyNPCData(entityData);
        entityData.method_10551("Pos");
        entityData.method_10551("Rotation");
        if (this.spawnerType == SpawnerType.GROUP_SPAWNER) {
            entityData.method_10551(ENTITY_UUID_TAG);
            log.debug("[Spawner] GROUP_SPAWNER: Use Preset UUID {} to allow multiple spawns", (Object)this.easyNPCPresetUUID);
        } else {
            log.debug("[Spawner] SINGLE/BOSS/DEFAULT_SPAWNER: Use UUID {} for unique entity", (Object)this.easyNPCUUID);
        }
        class_1952 cleanedSpawnData = new class_1952(entityData, spawnData.method_38097(), spawnData.method_59717());
        super.method_8277(level, blockPos, cleanedSpawnData);
    }

    public void method_31589(class_1937 level, class_2338 blockPos) {
        if (!this.hasEasyNPC() || !this.canSpawnBasedOnConditions(level, blockPos)) {
            return;
        }
        super.method_31589(level, blockPos);
    }

    public void method_31588(class_3218 serverLevel, class_2338 blockPos) {
        if (!this.hasEasyNPC() || this.spawnerType == SpawnerType.DEFAULT_SPAWNER) {
            super.method_31588(serverLevel, blockPos);
            return;
        }
        SpawnerAccessHelper spawnerAccess = (SpawnerAccessHelper)((Object)this);
        if (!this.isNearPlayer(serverLevel, blockPos)) {
            return;
        }
        if (spawnerAccess.getSpawnDelay() == -1) {
            this.resetSpawnDelay(serverLevel);
        }
        if (spawnerAccess.getSpawnDelay() > 0) {
            spawnerAccess.setSpawnDelay(spawnerAccess.getSpawnDelay() - 1);
            return;
        }
        if (!this.canSpawnBasedOnConditions((class_1937)serverLevel, blockPos)) {
            return;
        }
        boolean spawned = this.performSpawn(serverLevel, blockPos);
        if (spawned) {
            this.resetSpawnDelay(serverLevel);
        }
    }

    private void resetSpawnDelay(class_3218 serverLevel) {
        int maxDelay;
        SpawnerAccessHelper spawnerAccess;
        int minDelay = (spawnerAccess = (SpawnerAccessHelper)((Object)this)).getMinSpawnDelay();
        spawnerAccess.setSpawnDelay(minDelay >= (maxDelay = spawnerAccess.getMaxSpawnDelay()) ? minDelay : minDelay + serverLevel.field_9229.method_43048(maxDelay - minDelay));
    }

    private boolean isNearPlayer(class_3218 serverLevel, class_2338 blockPos) {
        int requiredPlayerRange = ((SpawnerAccessHelper)((Object)this)).getRequiredPlayerRange();
        return serverLevel.method_18458((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, (double)requiredPlayerRange);
    }

    private boolean performSpawn(class_3218 serverLevel, class_2338 blockPos) {
        if (this.storedPresetData == null || !this.storedPresetData.hasValidData()) {
            log.warn("[Spawner] No valid preset data available for spawning at {}", (Object)blockPos);
            return false;
        }
        class_5819 random = serverLevel.method_8409();
        SpawnerAccessHelper spawnerAccess = (SpawnerAccessHelper)((Object)this);
        int spawnCount = spawnerAccess.getSpawnCount();
        int spawnRange = spawnerAccess.getSpawnRange();
        boolean anySpawned = false;
        for (int i = 0; i < spawnCount; ++i) {
            if (!this.attemptSpawn(serverLevel, blockPos, random, spawnRange)) continue;
            anySpawned = true;
        }
        return anySpawned;
    }

    private boolean attemptSpawn(class_3218 serverLevel, class_2338 blockPos, class_5819 random, int spawnRange) {
        class_2487 entityData = this.storedPresetData.data().method_10553();
        this.prepareEntityDataWithUUIDs(entityData);
        double spawnX = (double)blockPos.method_10263() + (random.method_43058() - random.method_43058()) * (double)spawnRange + 0.5;
        double spawnY = (double)blockPos.method_10264() + (double)random.method_43048(3) - 1.0;
        double spawnZ = (double)blockPos.method_10260() + (random.method_43058() - random.method_43058()) * (double)spawnRange + 0.5;
        Optional entityTypeOpt = class_1299.method_17684((class_2487)entityData);
        if (entityTypeOpt.isEmpty()) {
            log.warn("[Spawner] Invalid entity type in preset data");
            return false;
        }
        class_1299 entityType = (class_1299)entityTypeOpt.get();
        if (!serverLevel.method_18026(entityType.method_58629(spawnX, spawnY, spawnZ))) {
            return false;
        }
        class_1297 entity = class_1299.method_17842((class_2487)entityData, (class_1937)serverLevel, loadedEntity -> {
            loadedEntity.method_5808(spawnX, spawnY, spawnZ, random.method_43057() * 360.0f, 0.0f);
            return loadedEntity;
        });
        if (entity == null) {
            log.warn("[Spawner] Failed to load entity from preset data");
            return false;
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5943((class_5425)serverLevel, serverLevel.method_8404(entity.method_24515()), class_3730.field_16469, null);
        }
        if (!serverLevel.method_30736(entity)) {
            log.debug("[Spawner] Failed to add entity to world at {}", (Object)entity.method_24515());
            return false;
        }
        class_2338 spawnPos = entity.method_24515();
        serverLevel.method_20290(2004, blockPos, 0);
        serverLevel.method_33596(entity, (class_6880)class_5712.field_28738, spawnPos);
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5990();
        }
        log.debug("[Spawner] Successfully spawned {} at {}", (Object)entity.method_5864(), (Object)spawnPos);
        return true;
    }

    private void prepareEntityDataWithUUIDs(class_2487 entityData) {
        if (this.spawnerType == SpawnerType.GROUP_SPAWNER) {
            entityData.method_25927(ENTITY_UUID_TAG, UUID.randomUUID());
        } else if (this.easyNPCUUID != null) {
            entityData.method_25927(ENTITY_UUID_TAG, this.easyNPCUUID);
        }
        if (this.easyNPCPresetUUID != null) {
            entityData.method_25927("PresetUUID", this.easyNPCPresetUUID);
        }
    }

    private boolean canSpawnBasedOnConditions(class_1937 level, class_2338 blockPos) {
        if (!this.hasEasyNPC() || this.storedPresetData == null) {
            return false;
        }
        if (this.spawnerType == SpawnerType.GROUP_SPAWNER) {
            if (this.easyNPCPresetUUID != null) {
                int n;
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    n = LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID, serverLevel);
                } else {
                    n = LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID);
                }
                int entityCount = n;
                return entityCount < this.getMaxNearbyEntities();
            }
        } else if (this.easyNPCUUID != null) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                class_1297 entity = serverLevel.method_14190(this.easyNPCUUID);
                return entity == null || !entity.method_5805();
            }
            EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(this.easyNPCUUID);
            return easyNPC == null || !easyNPC.getLivingEntity().method_5805();
        }
        return true;
    }

    public boolean hasEasyNPC() {
        return this.isEasyNPC;
    }

    private int getMaxNearbyEntities() {
        return ((SpawnerAccessHelper)((Object)this)).getMaxNearbyEntities();
    }

    public void method_8280(class_1937 level, class_2338 blockPos, class_2487 compoundTag) {
        class_2487 spawnData;
        super.method_8280(level, blockPos, compoundTag);
        if (compoundTag.method_10573(STORED_PRESET_DATA_TAG, 10)) {
            class_2487 presetDataTag = compoundTag.method_10562(STORED_PRESET_DATA_TAG);
            this.storedPresetData = PresetDataUtils.fromSpawnData(new class_1952(presetDataTag, Optional.empty(), Optional.empty()));
            if (this.storedPresetData != null && this.storedPresetData.hasValidData()) {
                this.easyNPCPresetUUID = this.storedPresetData.getPresetUUID();
                this.easyNPCUUID = this.storedPresetData.getEntityUUID();
                log.debug("[Spawner] Loaded stored preset data with PresetUUID: {}, EntityUUID: {}", (Object)this.easyNPCPresetUUID, (Object)this.easyNPCUUID);
            }
        } else if (compoundTag.method_10573(SPAWN_DATA_TAG, 10) && (spawnData = compoundTag.method_10562(SPAWN_DATA_TAG)).method_10545("entity")) {
            this.updateEasyNPCData(spawnData.method_10562("entity"));
        }
    }

    public class_2487 method_8272(class_2487 compoundTag) {
        class_2487 savedTag = super.method_8272(compoundTag);
        if (this.storedPresetData != null && this.storedPresetData.hasValidData()) {
            class_2487 presetDataTag = this.storedPresetData.data().method_10553();
            savedTag.method_10566(STORED_PRESET_DATA_TAG, (class_2520)presetDataTag);
            log.debug("[Spawner] Saved stored preset data with PresetUUID: {}, EntityUUID: {}", (Object)this.easyNPCPresetUUID, (Object)this.easyNPCUUID);
        }
        return savedTag;
    }

    public void method_8273(class_1937 level, class_2338 blockPos, int eventId) {
        level.method_8427(blockPos, class_2246.field_10260, eventId, 0);
    }

    private void updateEasyNPCData(class_2487 compoundTag) {
        this.isEasyNPC = false;
        this.easyNPCUUID = null;
        this.easyNPCPresetUUID = null;
        if (compoundTag.method_10545("id")) {
            class_2960 entityResourceLocation = class_2960.method_12829((String)compoundTag.method_10558("id"));
            boolean bl = this.isEasyNPC = entityResourceLocation != null && entityResourceLocation.method_12836().equals("easy_npc");
        }
        if (compoundTag.method_10545(ENTITY_UUID_TAG)) {
            this.easyNPCUUID = compoundTag.method_25926(ENTITY_UUID_TAG);
        }
        if (compoundTag.method_10545("PresetUUID")) {
            this.easyNPCPresetUUID = compoundTag.method_25926("PresetUUID");
        }
    }
}

