/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.model;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.class_1451;
import net.minecraft.class_3680;
import net.minecraft.class_582;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3680.class})
public class EasyNPCCatModelMixin<T extends class_1451>
extends class_582<T> {
    @Unique
    private EasyNPCModelManager easyNPC$modelManager;

    public EasyNPCCatModelMixin(class_630 modelPart) {
        super(modelPart);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="TAIL")})
    private void easyNpcModel(class_630 modelPart, CallbackInfo callbackInfo) {
        this.easyNPC$modelManager = new EasyNPCModelManager(modelPart).defineModelPart(ModelPartType.HEAD, this.field_3435).defineModelPart(ModelPartType.BODY, this.field_3437).defineModelPart(ModelPartType.RIGHT_FRONT_LEG, this.field_27457).defineModelPart(ModelPartType.LEFT_FRONT_LEG, this.field_27456).defineModelPart(ModelPartType.RIGHT_HIND_LEG, this.field_27455).defineModelPart(ModelPartType.LEFT_HIND_LEG, this.field_27454).defineModelPart(ModelPartType.TAIL1, this.field_3436).defineModelPart(ModelPartType.TAIL2, this.field_3442);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/animal/Cat;FFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupNpcAnimStart(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        EasyNPC easyNPC;
        if (entity instanceof EasyNPC && EasyNPCModel.setupAnimationStart(easyNPC = (EasyNPC)entity, this.easyNPC$modelManager)) {
            this.easyNPCAdjustTailToBody(easyNPC);
            callbackInfo.cancel();
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/animal/Cat;FFFFF)V"}, at={@At(value="TAIL")})
    private void setupNpcAnimEnd(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            EasyNPCModel.setupAnimationEnd(easyNPC, this.easyNPC$modelManager);
        }
    }

    @Unique
    private void easyNPCAdjustTailToBody(EasyNPC<?> easyNPC) {
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return;
        }
        CustomPosition bodyPosition = modelData.getModelPartPosition(ModelPartType.BODY);
        CustomScale bodyScale = modelData.getModelPartScale(ModelPartType.BODY);
        CustomRotation bodyRotation = modelData.getModelPartRotation(ModelPartType.BODY);
        if (bodyScale != null && bodyScale.hasChanged() && Math.abs(bodyScale.x() - 1.0f) + Math.abs(bodyScale.y() - 1.0f) + Math.abs(bodyScale.z() - 1.0f) > 0.5f) {
            this.field_3436.field_3665 = false;
            this.field_3442.field_3665 = false;
            return;
        }
        if (bodyRotation != null && bodyRotation.hasChanged() && Math.abs(bodyRotation.x()) + Math.abs(bodyRotation.y()) + Math.abs(bodyRotation.z()) > 0.1f) {
            this.field_3436.field_3665 = false;
            this.field_3442.field_3665 = false;
            return;
        }
        if (bodyPosition == null || !bodyPosition.hasChanged()) {
            return;
        }
        this.field_3436.field_3665 = true;
        this.field_3442.field_3665 = true;
        this.field_3436.field_3657 += bodyPosition.x();
        this.field_3436.field_3656 += bodyPosition.y();
        this.field_3436.field_3655 += bodyPosition.z();
        this.field_3442.field_3657 += bodyPosition.x();
        this.field_3442.field_3656 += bodyPosition.y();
        this.field_3442.field_3655 += bodyPosition.z();
    }
}

