/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.backup.BackupManager;
import de.markusbordihn.easynpc.entity.NPCEntityManager;
import de.markusbordihn.easynpc.io.DataFileHandler;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ServerEvents() {
    }

    public static void handleServerStarting(MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        log.info("{} Server is starting Events ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Constants.WORLD_DIR = minecraftServer.method_27050(class_5218.field_24188);
        DataFileHandler.registerServerDataFiles(minecraftServer);
    }

    public static void handleServerStarted(MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        log.info("{} Server started Events ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        NPCEntityManager.initialize(minecraftServer);
    }

    public static void handleServerTick(MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        BackupManager.performBackup();
    }

    public static void handleServerStopping(MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        log.info("{} Server is stopping, saving all dirty NPCs...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        NPCEntityManager.saveAllDirtyNPCs();
    }
}

