/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.saveddata.NPCEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class InfoCommand
extends Command {
    private InfoCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> InfoCommand.showNPCInfo((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"))));
    }

    private static int showNPCInfo(class_2168 context, EasyNPC<?> easyNPC) {
        UUID uuid = easyNPC.getEntityUUID();
        NPCEntityData.get(context.method_9211()).getEntry(uuid).ifPresentOrElse(entry -> {
            InfoCommand.sendSuccessMessage(context, "Easy NPC Info: " + String.valueOf(uuid), class_124.field_1065);
            if (entry.metadata().hasOwner()) {
                InfoCommand.sendSuccessMessage(context, "Owner: " + String.valueOf(entry.metadata().ownerUUID()), class_124.field_1068);
            }
            if (entry.metadata().hasEntityType()) {
                InfoCommand.sendSuccessMessage(context, "Type: " + entry.metadata().entityType(), class_124.field_1068);
            }
            if (entry.metadata().hasDimension()) {
                InfoCommand.sendSuccessMessage(context, "Dimension: " + entry.metadata().dimension(), class_124.field_1068);
            }
            if (entry.metadata().hasPreset()) {
                InfoCommand.sendSuccessMessage(context, "Preset: " + String.valueOf(entry.metadata().presetUUID()), class_124.field_1068);
            }
            if (entry.metadata().hasCustomIdentifier()) {
                InfoCommand.sendSuccessMessage(context, "Custom Identifier: " + String.valueOf(entry.metadata().customIdentifier()), class_124.field_1068);
            }
            InfoCommand.sendSuccessMessage(context, "NBT Data Size: " + entry.npcData().toString().length() + " chars", class_124.field_1080);
        }, () -> InfoCommand.sendFailureMessage(context, "NPC not found: " + String.valueOf(uuid)));
        return 1;
    }
}

